/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pcsc;

import de.intarsys.security.smartcard.pcsc.INativePCSCLib;
import de.intarsys.security.smartcard.pcsc.IPCSCContext;
import de.intarsys.security.smartcard.pcsc.IPCSCContextFactory;
import de.intarsys.security.smartcard.pcsc.NativePCSCLib;
import de.intarsys.security.smartcard.pcsc.PCSCException;
import de.intarsys.security.smartcard.pcsc.PCSCMultiContext;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.system.SystemTools;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

@SingletonClass
public class NativePCSCContextFactory
implements IPCSCContextFactory {
    private static final Logger Log = LoggerFactory.getLogger(NativePCSCContextFactory.class);
    private static final NativePCSCContextFactory ACTIVE = new NativePCSCContextFactory();
    public static final String SYSTEM_DEFAULT_LIBRARY = "";
    private final List<INativePCSCLib> libraries = new ArrayList<INativePCSCLib>(2);

    public static NativePCSCContextFactory get() {
        return ACTIVE;
    }

    private NativePCSCContextFactory() {
    }

    @Override
    public IPCSCContext establishContext(String id) throws PCSCException {
        if (this.libraries.isEmpty()) {
            Log.info("loading PC/SC system default library");
            NativePCSCLib lib = new NativePCSCLib();
            lib.setPath(SYSTEM_DEFAULT_LIBRARY);
            lib.setUseExecutorThread(false);
            lib.setUseBlockingGetStatusChange(SystemTools.isWindows());
            lib.initialize();
        }
        ArrayList<IPCSCContext> contexts = new ArrayList<IPCSCContext>(this.libraries.size());
        PCSCException cause = null;
        for (INativePCSCLib pcsclib : this.libraries) {
            try {
                IPCSCContext context = pcsclib.establishContext(id);
                contexts.add(context);
            }
            catch (PCSCException e) {
                cause = e;
                Log.error("Failed to establish PC/SC context", (Throwable)e);
            }
        }
        if (contexts.size() == 0) {
            if (cause == null) {
                throw new PCSCException("Failed to establish PC/SC context");
            }
            throw cause;
        }
        if (contexts.size() == 1) {
            return (IPCSCContext)contexts.get(0);
        }
        return new PCSCMultiContext(this, contexts);
    }

    public List<INativePCSCLib> getLibraries() {
        return new ArrayList<INativePCSCLib>(this.libraries);
    }

    public void registerLibrary(INativePCSCLib pcsclib) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("Adding library " + pcsclib);
        }
        this.libraries.add(pcsclib);
    }

    public String toString() {
        return "PCSC context factory";
    }
}

