/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pcsc;

import de.intarsys.security.smartcard.pcsc.IPCSCCardReader;
import de.intarsys.security.smartcard.pcsc.IPCSCContext;
import de.intarsys.security.smartcard.pcsc.PCSCCardReaderState;
import de.intarsys.security.smartcard.pcsc.PCSCException;
import de.intarsys.tools.oid.IOIDGenerator;
import de.intarsys.tools.oid.PronouncableOIDGenerator;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCSCCardReader
implements IPCSCCardReader {
    private static final IOIDGenerator<String> OID_GENERATOR = new PronouncableOIDGenerator();
    private static final Logger Log = LoggerFactory.getLogger(PCSCCardReader.class);
    private final String name;
    private final IPCSCContext context;
    private final String id;

    public PCSCCardReader(IPCSCContext context, String readerName) {
        this.context = context;
        this.name = readerName;
        this.id = (String)OID_GENERATOR.createOID();
    }

    @Override
    public IPCSCContext getContext() {
        return this.context;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PCSCCardReaderState getState() throws PCSCException {
        try {
            return this.getContext().getStatusChange(this.getName(), null, 0);
        }
        catch (TimeoutException e) {
            return PCSCCardReaderState.UNAWARE;
        }
    }

    public String toString() {
        return "pcscreader " + this.getId() + ", " + this.getName();
    }
}

