/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pcsc;

import de.intarsys.security.smartcard.pcsc.nativec.SCARD_READERSTATE;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.string.IPrettyPrintable;
import de.intarsys.tools.string.PrettyPrinter;
import java.util.HashMap;
import java.util.Map;

public class PCSCCardReaderState
implements IPrettyPrintable {
    public static final PCSCCardReaderState UNAWARE = new PCSCCardReaderState(null);
    private final SCARD_READERSTATE readerState;
    private static final Map<Integer, String> STATE_LABELS = new HashMap<Integer, String>();

    protected PCSCCardReaderState(SCARD_READERSTATE readerState) {
        this.readerState = readerState;
    }

    public byte[] getATR() {
        if (this.readerState == null) {
            return null;
        }
        byte[] atr = this.readerState.getATR();
        if (atr.length < 5) {
            return null;
        }
        return atr;
    }

    public int getCurrentState() {
        if (this.readerState == null) {
            return 0;
        }
        return this.readerState.getCurrentState();
    }

    public int getEventState() {
        if (this.readerState == null) {
            return 0;
        }
        return this.readerState.getEventState();
    }

    public String getReader() {
        if (this.readerState == null) {
            return null;
        }
        return this.readerState.getReader();
    }

    public boolean isATRMatch() {
        return (this.getEventState() & 0x40) != 0;
    }

    public boolean isChanged() {
        return (this.getEventState() & 2) != 0;
    }

    public boolean isEmpty() {
        return (this.getEventState() & 0x10) != 0;
    }

    public boolean isExclusive() {
        return (this.getEventState() & 0x80) != 0;
    }

    public boolean isIgnore() {
        return (this.getEventState() & 1) != 0;
    }

    public boolean isInUse() {
        return (this.getEventState() & 0x100) != 0;
    }

    public boolean isMute() {
        return (this.getEventState() & 0x200) != 0;
    }

    public boolean isPresent() {
        return (this.getEventState() & 0x20) != 0;
    }

    protected boolean isSet(int state, Integer flag) {
        return (state & flag) != 0;
    }

    public boolean isUnavailable() {
        return (this.getEventState() & 8) != 0;
    }

    public boolean isUnknown() {
        return (this.getEventState() & 4) != 0;
    }

    private boolean isUnpowered() {
        return (this.getEventState() & 0x400) != 0;
    }

    public final String toString() {
        return new PrettyPrinter().toString((Object)this);
    }

    public void toString(PrettyPrinter printer) {
        if (this.readerState == null) {
            printer.appendString("<unaware>");
            return;
        }
        printer.appendMember("reader", (Object)this.readerState.getReader(), null);
        printer.appendMember("currentState", (Object)Integer.toBinaryString(this.readerState.getCurrentState()), this.toStringState(this.readerState.getCurrentState()));
        printer.appendMember("eventState", (Object)Integer.toBinaryString(this.readerState.getEventState()), this.toStringState(this.readerState.getEventState()));
        printer.appendMember("cAtr", (Object)this.readerState.getATRSize(), null);
        printer.appendMember("bAtr", (Object)HexTools.bytesToHexString((byte[])this.readerState.getATR()), null);
    }

    protected String toStringState(int state) {
        StringBuilder builder = new StringBuilder();
        for (Integer flag : STATE_LABELS.keySet()) {
            if (!this.isSet(state, flag)) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(STATE_LABELS.get(flag));
        }
        return builder.toString();
    }

    static {
        STATE_LABELS.put(64, "ATRMATCH");
        STATE_LABELS.put(2, "CHANGED");
        STATE_LABELS.put(16, "EMPTY");
        STATE_LABELS.put(128, "EXCLUSIVE");
        STATE_LABELS.put(1, "IGNORE");
        STATE_LABELS.put(256, "INUSE");
        STATE_LABELS.put(512, "MUTE");
        STATE_LABELS.put(32, "PRESENT");
        STATE_LABELS.put(8, "UNAVAILABLE");
        STATE_LABELS.put(0, "UNAWARE");
        STATE_LABELS.put(4, "UNKNOWN");
        STATE_LABELS.put(1024, "UNPOWERED");
    }
}

