/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pcsc;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.NativeBuffer;
import de.intarsys.security.smartcard.pcsc.CardStatus;
import de.intarsys.security.smartcard.pcsc.CommonPCSCContext;
import de.intarsys.security.smartcard.pcsc.IPCSCConnection;
import de.intarsys.security.smartcard.pcsc.PCSCContextFactory;
import de.intarsys.security.smartcard.pcsc.PCSCException;
import de.intarsys.security.smartcard.pcsc.PCSCTools;
import de.intarsys.security.smartcard.pcsc.nativec.NativePcscDword;
import de.intarsys.security.smartcard.pcsc.nativec.SCARDHANDLE;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.hex.HexTools;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class PCSCConnection
implements IPCSCConnection {
    private static final Logger Log = LoggerFactory.getLogger(PCSCConnection.class);
    private static final AtomicInteger Counter = new AtomicInteger(0);
    private static final Object lockGetMapped = new Object();
    private final String id;
    private final CommonPCSCContext context;
    private final SCARDHANDLE hCard;
    private final INativeHandle protocolHandle;
    private final int shareMode;
    private final int protocol;
    private NativeBuffer sendBuffer;
    private NativeBuffer recvBuffer;
    private NativePcscDword nRecvLength;

    public PCSCConnection(CommonPCSCContext context, String id, SCARDHANDLE hCard, int shareMode, int protocol, INativeHandle protocolHandle) {
        this.id = id;
        this.context = context;
        this.hCard = hCard;
        this.shareMode = shareMode;
        this.protocol = protocol;
        this.protocolHandle = protocolHandle;
        int count = Counter.incrementAndGet();
        Log.debug("{} created, handle {}, share mode {}, protocol {}, {} active", new Object[]{this.getLogLabel(), Long.toHexString(hCard.longValue()), shareMode, protocol, count});
    }

    @Override
    public void beginTransaction() throws PCSCException {
        Log.trace("{} begin transaction", (Object)this.getLogLabel());
        this.getContext().fromConnectionBeginTransaction(this);
    }

    @Override
    public byte[] control(int controlCode, byte[] inBuffer, int inBufferOffset, int inBufferLength, int outBufferSize) throws PCSCException {
        int tempLength;
        Log.trace("{} control 0x{}", (Object)this.getLogLabel(), (Object)Integer.toHexString(controlCode));
        this.logBytes(">>", inBuffer, inBufferOffset, inBufferLength, false);
        if (inBuffer != null) {
            if (this.sendBuffer == null || this.sendBuffer.getSize() < inBufferLength) {
                tempLength = Math.max(inBufferLength, 512);
                this.sendBuffer = new NativeBuffer(tempLength);
            }
            this.sendBuffer.setByteArray(0, inBuffer, inBufferOffset, inBufferLength);
        }
        if (this.recvBuffer == null || this.recvBuffer.getSize() < outBufferSize) {
            tempLength = Math.max(outBufferSize, 4096);
            this.recvBuffer = new NativeBuffer(tempLength);
            this.nRecvLength = new NativePcscDword();
        }
        this.nRecvLength.setValue(outBufferSize);
        int rc = this.getContext().getPcsc().SCardControl(this.hCard, controlCode, this.sendBuffer, inBufferLength, this.recvBuffer, this.recvBuffer.getSize(), this.nRecvLength);
        int size = this.nRecvLength.intValue();
        PCSCException.checkReturnCode(rc, size);
        byte[] result = this.recvBuffer.getByteArray(0, size);
        this.logBytes("<<", result, 0, result.length, false);
        return result;
    }

    @Override
    public byte[] controlMapped(int code, byte[] inBuffer, int inBufferOffset, int inBufferLength, int outBufferSize) throws PCSCException {
        int controlCode = PCSCContextFactory.mapControlCode(code);
        Object object = lockGetMapped;
        synchronized (object) {
            try {
                return this.control(controlCode, inBuffer, inBufferOffset, inBufferLength, outBufferSize);
            }
            catch (PCSCException e1) {
                if (PCSCContextFactory.isPcscLite()) {
                    Log.trace("{} control mapped request failed ({})", (Object)this.getLogLabel(), (Object)ExceptionTools.getMessage((Throwable)e1));
                    throw e1;
                }
                Log.debug("{} control mapped request failed - retry PCSC lite version", (Object)this.getLogLabel());
                PCSCContextFactory.setPcscLite(true);
                controlCode = PCSCContextFactory.mapControlCode(code);
                try {
                    return this.control(controlCode, inBuffer, inBufferOffset, inBufferLength, outBufferSize);
                }
                catch (PCSCException e2) {
                    PCSCContextFactory.setPcscLite(false);
                    Log.trace("{} control mapped request failed ({})", (Object)this.getLogLabel(), (Object)ExceptionTools.getMessage((Throwable)e1));
                    throw e1;
                }
            }
        }
    }

    @Override
    public void disconnect(int disposition) throws PCSCException {
        int count = Counter.decrementAndGet();
        Log.debug("{} disconnect {}, {} active", new Object[]{this.getLogLabel(), disposition, count});
        this.getContext().fromConnectionDisconnect(this, disposition);
    }

    @Override
    public void endTransaction(int disposition) throws PCSCException {
        Log.trace("{} end transaction {}", (Object)this.getLogLabel(), (Object)disposition);
        this.getContext().fromConnectionEndTransaction(this, disposition);
    }

    @Override
    public byte[] getAttrib(int attrId) throws PCSCException {
        Log.trace("{} get attrib {}", (Object)this.getLogLabel(), (Object)Integer.toHexString(attrId));
        try {
            byte[] result = PCSCTools.BufferHelper.call(this.context, (buffer, bufferSize) -> this.getContext().getPcsc().SCardGetAttrib(this.hCard, attrId, (NativeBuffer)buffer, (NativePcscDword)((Object)bufferSize)));
            this.logBytes("<<", result, 0, result.length, false);
            return result;
        }
        catch (PCSCException ex) {
            Log.trace("{} get attrib {}, exception {}", new Object[]{this.getLogLabel(), attrId, ex.getErrorCode()});
            return new byte[0];
        }
    }

    @Override
    public CommonPCSCContext getContext() {
        return this.context;
    }

    protected SCARDHANDLE getHCard() {
        return this.hCard;
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected String getLogLabel() {
        return "PCSCConnection " + this.getId();
    }

    @Override
    public int getProtocol() {
        return this.protocol;
    }

    @Override
    public int getShareMode() {
        return this.shareMode;
    }

    @Override
    public CardStatus getStatus() throws PCSCException {
        NativePcscDword nativeState = new NativePcscDword();
        NativePcscDword nativeProtocol = new NativePcscDword();
        int atrSize = 32;
        NativeBuffer nativeAtr = new NativeBuffer(atrSize);
        NativePcscDword nativeAtrSize = new NativePcscDword(atrSize);
        byte[] result = PCSCTools.BufferHelper.call(this.context, (buffer, bufferSize) -> this.getContext().getPcsc().SCardStatus(this.hCard, (INativeObject)buffer, (NativePcscDword)((Object)bufferSize), nativeState, nativeProtocol, nativeAtr, nativeAtrSize));
        return new CardStatus(new String(result).split("\u0000"), nativeState.intValue(), nativeProtocol.intValue(), nativeAtr.getByteArray(0, nativeAtrSize.intValue()));
    }

    protected void logBytes(String mode, byte[] bytes, int offset, int length, boolean sensitiveContent) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            String strLength = String.format("%04d", length);
            Object strData = sensitiveContent ? (bytes == null ? "" : HexTools.bytesToHexString((byte[])bytes, (int)offset, (int)4, (boolean)true) + " <sensitive content omitted>") : (bytes == null ? "" : HexTools.bytesToHexString((byte[])bytes, (int)offset, (int)length, (boolean)true));
            Log.trace("{} {} [{}]: {}", new Object[]{this.getLogLabel(), mode, strLength, strData});
        }
    }

    @Override
    public void reconnect(int shareMode, int protocol, int initialization) throws PCSCException {
        Log.trace("{} reconnect {}, {}, {}", new Object[]{this.getLogLabel(), shareMode, protocol, initialization});
        NativePcscDword activeProtocol = new NativePcscDword();
        int rc = this.getContext().getPcsc().SCardReconnect(this.hCard, shareMode, protocol, initialization, activeProtocol);
        PCSCException.checkReturnCode(rc);
    }

    public String toString() {
        return this.getLogLabel();
    }

    @Override
    public byte[] transmit(byte[] apdu, int apduOffset, int apduLength, int recvLength, boolean sensitiveContent) throws PCSCException {
        int tempLength;
        this.logBytes(">>", apdu, apduOffset, apduLength, sensitiveContent);
        if (this.sendBuffer == null || this.sendBuffer.getSize() < apduLength) {
            tempLength = Math.max(apduLength, 512);
            this.sendBuffer = new NativeBuffer(tempLength);
        }
        this.sendBuffer.setByteArray(0, apdu, apduOffset, apduLength);
        if (this.recvBuffer == null || this.recvBuffer.getSize() < recvLength) {
            tempLength = Math.max(recvLength, 4096);
            this.recvBuffer = new NativeBuffer(tempLength);
            this.nRecvLength = new NativePcscDword();
        }
        this.nRecvLength.setValue(recvLength);
        int rc = this.getContext().getPcsc().SCardTransmit(this.hCard, this.protocolHandle, (INativeObject)this.sendBuffer, apduLength, null, this.recvBuffer, this.nRecvLength);
        PCSCException.checkReturnCode(rc);
        int responseSize = this.nRecvLength.intValue();
        byte[] result = this.recvBuffer.getByteArray(0, responseSize);
        this.logBytes("<<", result, 0, result.length, false);
        return result;
    }
}

