/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pcsc;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.NativeLongLP64;
import de.intarsys.nativec.type.NativeString;
import de.intarsys.security.smartcard.pcsc.CommonPCSCContext;
import de.intarsys.security.smartcard.pcsc.INativePCSCLib;
import de.intarsys.security.smartcard.pcsc.IPCSCCardReader;
import de.intarsys.security.smartcard.pcsc.IPCSCConnection;
import de.intarsys.security.smartcard.pcsc.PCSCCardReader;
import de.intarsys.security.smartcard.pcsc.PCSCConnection;
import de.intarsys.security.smartcard.pcsc.PCSCException;
import de.intarsys.security.smartcard.pcsc.PCSCTools;
import de.intarsys.security.smartcard.pcsc.nativec.NativePcscDword;
import de.intarsys.security.smartcard.pcsc.nativec.SCARDCONTEXT;
import de.intarsys.security.smartcard.pcsc.nativec.SCARDHANDLE;
import de.intarsys.security.smartcard.pcsc.nativec.SCARD_READERSTATE;
import de.intarsys.security.smartcard.pcsc.nativec._IPCSC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCSCContext
extends CommonPCSCContext {
    private static final Logger Log = LoggerFactory.getLogger(PCSCContext.class);
    private int connectCounter = 0;
    private boolean interrupted;

    public PCSCContext(INativePCSCLib lib, String id, _IPCSC pcsc) throws PCSCException {
        this(lib, id, pcsc, PCSCContext.establish(pcsc));
    }

    public PCSCContext(INativePCSCLib lib, String id, _IPCSC pcsc, SCARDCONTEXT pHContext) {
        super(lib, id, pcsc, pHContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelGetStatusChange() throws PCSCException {
        Log.trace("{} cancel getStatusChange", (Object)this);
        if (this.isUseBlockingGetStatusChange()) {
            SCARDCONTEXT tempContext = this.getHContext();
            if (tempContext != null) {
                int rc = this.getPcsc().SCardCancel(tempContext);
                if (!this.isDisposed()) {
                    PCSCException.checkReturnCode(rc);
                }
            }
        } else {
            Object object = this.lock;
            synchronized (object) {
                this.interrupted = true;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPCSCConnection connect(String id, String readerName, int shareMode, int protocol) throws PCSCException {
        Object tempContext;
        Log.trace("{} connect id {}, {}, {}, {}", new Object[]{this, id, readerName, shareMode, protocol});
        NativeString nReaderName = new NativeString(readerName);
        NativeLongLP64 phCard = new NativeLongLP64();
        NativePcscDword activeProtocol = new NativePcscDword();
        try {
            Object object = this.lock;
            synchronized (object) {
                ++this.connectCounter;
            }
            tempContext = this.getHContext();
            if (tempContext == null) {
                throw new PCSCException(-2146435069);
            }
            int rc = this.getPcsc().SCardConnect((SCARDCONTEXT)tempContext, nReaderName, shareMode, protocol, phCard, activeProtocol);
            PCSCException.checkReturnCode(rc);
        }
        finally {
            tempContext = this.lock;
            synchronized (tempContext) {
                --this.connectCounter;
            }
        }
        INativeHandle protocolHandle = this.getProtocolHandle(activeProtocol.intValue());
        return new PCSCConnection(this, id, new SCARDHANDLE(phCard.longValue()), shareMode, activeProtocol.intValue(), protocolHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void getStatusChange(SCARD_READERSTATE readerState, int millisecTimeout) throws PCSCException {
        try {
            long start = System.currentTimeMillis();
            Object object = this.lock;
            synchronized (object) {
                this.interrupted = false;
            }
            int currentState = readerState.getCurrentState();
            while (readerState.getEventState() == currentState) {
                SCARDCONTEXT tempContext;
                if (!this.isUseBlockingGetStatusChange()) {
                    readerState.setCurrentState(0);
                }
                if ((tempContext = this.getHContext()) == null) {
                    throw new PCSCException(-2146435070);
                }
                int rc = this.getPcsc().SCardGetStatusChange(tempContext, millisecTimeout, (INativeObject)readerState, 1L);
                PCSCException.checkReturnCode(rc);
                if (this.isUseBlockingGetStatusChange() || readerState.getEventState() != currentState) continue;
                Object object2 = this.lock;
                synchronized (object2) {
                    if (this.interrupted) {
                        throw new PCSCException(-2146435070);
                    }
                    if (millisecTimeout == 0) {
                        return;
                    }
                    long timePassed = System.currentTimeMillis() - start;
                    if (millisecTimeout > 0 && timePassed >= (long)millisecTimeout) {
                        throw new PCSCException(-2146435062);
                    }
                    try {
                        this.lock.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new PCSCException(-2146435070);
                    }
                    if (this.interrupted) {
                        throw new PCSCException(-2146435070);
                    }
                }
            }
            return;
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.interrupted = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isReleaseVeto() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectCounter > 0;
        }
    }

    @Override
    public List<IPCSCCardReader> listReaders() throws PCSCException {
        byte[] result;
        SCARDCONTEXT nativeContext = this.getHContext();
        if (nativeContext == null) {
            return Collections.emptyList();
        }
        try {
            result = PCSCTools.BufferHelper.call(this, (buffer, bufferSize) -> this.getPcsc().SCardListReaders(nativeContext, null, (INativeObject)buffer, (NativePcscDword)((Object)bufferSize)));
        }
        catch (PCSCException ex) {
            if (ex.getErrorCode() == -2146435026) {
                return Collections.emptyList();
            }
            throw ex;
        }
        ArrayList<IPCSCCardReader> readerList = new ArrayList<IPCSCCardReader>(3);
        int start = 0;
        for (int i = 0; i < result.length; ++i) {
            if (result[i] != 0) continue;
            if (i > start) {
                readerList.add(new PCSCCardReader(this, new String(result, start, i - start)));
            }
            start = i + 1;
        }
        return readerList;
    }
}

