/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pcsc;

import de.intarsys.security.smartcard.pcsc.IPCSCContextFactory;
import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.servicelocator.ServiceLocator;
import de.intarsys.tools.system.SystemTools;

@SingletonProvider
public class PCSCContextFactory {
    private static boolean pcscLite = false;

    public static IPCSCContextFactory get() {
        return (IPCSCContextFactory)ServiceLocator.get().get(IPCSCContextFactory.class);
    }

    public static synchronized boolean isPcscLite() {
        return pcscLite;
    }

    public static synchronized int mapControlCode(int code) {
        if (pcscLite) {
            return 0x42000000 | code;
        }
        return 0x310000 | code << 2;
    }

    protected static synchronized void setPcscLite(boolean pPcscLite) {
        pcscLite = pPcscLite;
    }

    static {
        pcscLite = !SystemTools.isWindows();
    }
}

