/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pcsc;

import de.intarsys.security.smartcard.pcsc.PACKAGE;
import de.intarsys.security.smartcard.pcsc.PCSCCardReset;
import de.intarsys.security.smartcard.pcsc.PCSCCardUnavailable;
import de.intarsys.security.smartcard.pcsc.PCSCSharingViolation;
import de.intarsys.security.smartcard.pcsc.nativec._PCSC_RETURN_CODES;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ClassTools;

public class PCSCException
extends Exception
implements _PCSC_RETURN_CODES {
    private static final long serialVersionUID = 1L;
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private int errorCode = 0;

    public static void checkReturnCode(int rc) throws PCSCException {
        if (rc == 0) {
            return;
        }
        if (rc == -2146434968 || rc == -2146434969) {
            throw new PCSCCardReset();
        }
        if (rc == -2146434967 || rc == -2146434970 || rc == -2146434971 || rc == -2146435044 || rc == -2146435060) {
            throw new PCSCCardUnavailable(rc);
        }
        if (rc == -2146435061) {
            throw new PCSCSharingViolation(rc);
        }
        throw new PCSCException(rc);
    }

    public static void checkReturnCode(int rc, int size) throws PCSCException {
        if (rc == 122 || rc == -2146435064) {
            throw new PCSCException(rc, ": at least " + size + " bytes required");
        }
        PCSCException.checkReturnCode(rc);
    }

    public PCSCException(int errorCode) {
        this.errorCode = errorCode;
    }

    public PCSCException(int errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public PCSCException(String message) {
        super(message);
    }

    public PCSCException(String message, Throwable cause) {
        super(message, cause);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        String name;
        String tempMsg = super.getMessage();
        if (this.errorCode == 0) {
            return tempMsg;
        }
        if (tempMsg == null) {
            tempMsg = "";
        }
        if ((name = ClassTools.getConstantName(_PCSC_RETURN_CODES.class, (Object)this.errorCode)) != null) {
            String msg = Msg.getPattern("PCSCException.error." + name);
            if (msg != null) {
                return Msg.format(msg, new Object[]{tempMsg});
            }
            return Msg.getString("PCSCException.error_default", new Object[]{name, tempMsg});
        }
        return Msg.getString("PCSCException.error_default", new Object[]{this.errorCode, tempMsg});
    }
}

