/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pcsc;

import de.intarsys.security.smartcard.pcsc.IPCSCCardReader;
import de.intarsys.security.smartcard.pcsc.IPCSCConnection;
import de.intarsys.security.smartcard.pcsc.IPCSCContext;
import de.intarsys.security.smartcard.pcsc.IPCSCContextFactory;
import de.intarsys.security.smartcard.pcsc.PCSCCardReaderState;
import de.intarsys.security.smartcard.pcsc.PCSCException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class PCSCMultiContext
implements IPCSCContext {
    private final List<IPCSCContext> contexts;
    private final IPCSCContextFactory system;
    private boolean disposed = false;

    public PCSCMultiContext(IPCSCContextFactory system, List<IPCSCContext> contexts) {
        this.system = system;
        this.contexts = contexts;
    }

    public void cancelGetStatusChange() throws PCSCException {
    }

    @Override
    public IPCSCConnection connect(String id, String readerName, int shareMode, int protocol) throws PCSCException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        PCSCMultiContext pCSCMultiContext = this;
        synchronized (pCSCMultiContext) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
        }
        for (IPCSCContext context : this.contexts) {
            try {
                context.dispose();
            }
            catch (PCSCException pCSCException) {}
        }
    }

    @Override
    public IPCSCContext establishContext(String id) throws PCSCException {
        return this.system.establishContext(id);
    }

    @Override
    public PCSCCardReaderState getStatusChange(String readerName, PCSCCardReaderState currentState, int millisecTimeout) throws PCSCException, TimeoutException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDisposed() {
        PCSCMultiContext pCSCMultiContext = this;
        synchronized (pCSCMultiContext) {
            return this.disposed;
        }
    }

    @Override
    public List<IPCSCCardReader> listReaders() throws PCSCException {
        ArrayList<IPCSCCardReader> readers = new ArrayList<IPCSCCardReader>();
        for (IPCSCContext context : this.contexts) {
            readers.addAll(context.listReaders());
        }
        return readers;
    }
}

