/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pcsc;

import de.intarsys.security.smartcard.pcsc.IPCSCCardReader;
import de.intarsys.security.smartcard.pcsc.IPCSCContext;
import de.intarsys.security.smartcard.pcsc.PCSCCardReaderState;
import de.intarsys.security.smartcard.pcsc.PCSCException;
import de.intarsys.tools.exception.ExceptionTools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCSCStatusMonitor {
    private static final Logger Log = LoggerFactory.getLogger(PCSCStatusMonitor.class);
    private final IPCSCCardReader reader;
    private Thread monitorThread;
    private PCSCCardReaderState newReaderState = null;
    private PCSCCardReaderState oldReaderState = null;
    private IPCSCContext pcscContext;
    private final List<IStatusListener> listeners = new ArrayList<IStatusListener>();
    private final Object lock = new Object();

    public PCSCStatusMonitor(IPCSCCardReader cardReader) {
        this.reader = cardReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(IStatusListener listener) {
        Object object = this.lock;
        synchronized (object) {
            boolean start = this.listeners.isEmpty();
            this.listeners.add(listener);
            if (start) {
                this.start();
            }
        }
    }

    protected IPCSCContext getPcscContext() {
        return this.pcscContext;
    }

    public IPCSCCardReader getReader() {
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean monitor() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.monitorThread == null) {
                    return false;
                }
            }
            this.newReaderState = this.getPcscContext().getStatusChange(this.getReader().getName(), this.oldReaderState, -1);
            if (this.newReaderState.isIgnore() || this.newReaderState.isMute() || this.newReaderState.isUnavailable()) {
                this.oldReaderState = this.newReaderState;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return false;
                }
                return true;
            }
            if (this.newReaderState.isPresent() && (this.oldReaderState == null || this.oldReaderState.isEmpty())) {
                try {
                    this.oldReaderState = this.newReaderState = this.getPcscContext().getStatusChange(this.getReader().getName(), this.newReaderState, 50);
                    if (this.newReaderState.isEmpty()) {
                        Log.debug("{} ignore PRESENT", (Object)this);
                        return true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.onStatusChange(this.newReaderState);
            this.oldReaderState = this.newReaderState;
        }
        catch (PCSCException e) {
            if (this.getPcscContext().isDisposed()) {
                Log.trace("{} terminated", (Object)this);
                return false;
            }
            if (e.getErrorCode() == -2146435026) {
                Log.trace("{} reader disconnected", (Object)this);
                return false;
            }
            if (e.getErrorCode() == -2146435070) {
                Log.trace("{} canceled", (Object)this);
                return true;
            }
            Log.trace("{} PCSC Exception", (Object)this, (Object)e);
            this.oldReaderState = null;
            this.onException(e);
            return false;
        }
        catch (TimeoutException e) {
            Log.trace("{} Timeout Exception", (Object)this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void monitorLoop() {
        try {
            Object object = this.lock;
            synchronized (object) {
                block11: {
                    if (this.monitorThread != null) break block11;
                    return;
                }
                this.pcscContext = this.getReader().getContext().establishContext(this.getReader().getId());
            }
            while (this.monitor()) {
            }
        }
        catch (Exception e) {
            Log.warn("{} error monitoring status ({})", (Object)this, (Object)ExceptionTools.getMessage((Throwable)e));
        }
        finally {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onException(PCSCException e) {
        ArrayList<IStatusListener> temp;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            temp = new ArrayList<IStatusListener>(this.listeners);
        }
        for (IStatusListener listener : temp) {
            listener.onException(this.getReader(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onStatusChange(PCSCCardReaderState cardReaderState) {
        ArrayList<IStatusListener> temp;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            temp = new ArrayList<IStatusListener>(this.listeners);
        }
        for (IStatusListener listener : temp) {
            listener.onStatusChange(this.getReader(), cardReaderState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusListener(IStatusListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.listeners.remove(listener) && this.listeners.isEmpty()) {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.monitorThread != null) {
                return;
            }
            String name = this.toString();
            this.monitorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    PCSCStatusMonitor.this.monitorLoop();
                }
            }, name);
            this.monitorThread.setDaemon(true);
            this.monitorThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        IPCSCContext temp;
        Object object = this.lock;
        synchronized (object) {
            if (this.monitorThread == null) {
                return;
            }
            this.monitorThread = null;
            temp = this.getPcscContext();
            this.listeners.clear();
        }
        if (temp != null) {
            try {
                temp.dispose();
            }
            catch (PCSCException e) {
                Log.trace("{} error releasing context", (Object)this);
            }
        }
    }

    public String toString() {
        return "pcsc monitor " + this.getReader().getId();
    }

    public static interface IStatusListener {
        public void onException(IPCSCCardReader var1, PCSCException var2);

        public void onStatusChange(IPCSCCardReader var1, PCSCCardReaderState var2);
    }
}

