/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pcsc;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.type.NativeBuffer;
import de.intarsys.nativec.type.NativeBufferType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeVoid;
import de.intarsys.security.smartcard.pcsc.CommonPCSCContext;
import de.intarsys.security.smartcard.pcsc.PCSCException;
import de.intarsys.security.smartcard.pcsc.nativec.NativePcscDword;
import de.intarsys.security.smartcard.pcsc.nativec._IPCSC;
import java.util.function.BiFunction;

public final class PCSCTools {
    public static IBufferHelper BufferHelper = _IPCSC.SupportsAutoallocate ? new Autoallocate() : new Preallocate();
    public static int DirectConnectProtocol = _IPCSC.SupportsProtocolUndefined ? 0 : 3;

    public static String toString(byte[] buffer) {
        int length;
        if (buffer == null || buffer.length == 0) {
            return "";
        }
        for (length = buffer.length; length > 0 && buffer[length - 1] == 0; --length) {
        }
        return new String(buffer, 0, length);
    }

    private PCSCTools() {
    }

    private static class Autoallocate
    implements IBufferHelper {
        private NativePcscDword bufferSize = new NativePcscDword();
        private NativeBuffer buffer = new NativeBuffer(NativeObject.SIZE_PTR);

        private Autoallocate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized byte[] call(CommonPCSCContext context, BiFunction<NativeBuffer, NativePcscDword, Integer> function) throws PCSCException {
            this.bufferSize.setValue(-1L);
            int rc = function.apply(this.buffer, this.bufferSize);
            PCSCException.checkReturnCode(rc);
            INativeHandle handle = this.buffer.getNativeHandle(0);
            try {
                byte[] byArray = ((NativeBuffer)NativeBufferType.create((int)this.bufferSize.intValue()).createNative(handle)).getBytes();
                return byArray;
            }
            finally {
                context.getPcsc().SCardFreeMemory(context.getHContext(), NativeVoid.META.createNative(handle));
            }
        }
    }

    private static class Preallocate
    implements IBufferHelper {
        NativePcscDword bufferSize = new NativePcscDword(0L);
        NativeBuffer buffer = new NativeBuffer(256);

        private Preallocate() {
        }

        @Override
        public synchronized byte[] call(CommonPCSCContext context, BiFunction<NativeBuffer, NativePcscDword, Integer> function) throws PCSCException {
            int rc;
            while (true) {
                this.bufferSize.setValue(this.buffer.getSize());
                rc = function.apply(this.buffer, this.bufferSize);
                if (rc != -2146435064) break;
                this.buffer = new NativeBuffer(this.bufferSize.intValue());
            }
            PCSCException.checkReturnCode(rc);
            return this.buffer.getByteArray(0, this.bufferSize.intValue());
        }
    }

    static interface IBufferHelper {
        public byte[] call(CommonPCSCContext var1, BiFunction<NativeBuffer, NativePcscDword, Integer> var2) throws PCSCException;
    }
}

