/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pcsc.nativec;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeArray;
import de.intarsys.nativec.type.NativeByte;
import de.intarsys.nativec.type.NativeStaticStruct;
import de.intarsys.nativec.type.NativeString;
import de.intarsys.nativec.type.NativeStruct;
import de.intarsys.nativec.type.NativeStructType;
import de.intarsys.nativec.type.NativeVoid;
import de.intarsys.nativec.type.StructMember;
import de.intarsys.security.smartcard.pcsc.nativec.NativePcscDword;

public class SCARD_READERSTATE
extends NativeStaticStruct {
    public static final MetaClass META = new MetaClass(SCARD_READERSTATE.class);
    private static final StructMember cbAtr;
    private static final StructMember dwCurrentState;
    private static final StructMember dwEventState;
    private static final StructMember rgbAtr;
    private static final StructMember szReader;

    public SCARD_READERSTATE() {
    }

    protected SCARD_READERSTATE(INativeHandle nativeHandle) {
        super(nativeHandle);
    }

    public byte[] getATR() {
        int size = this.getATRSize();
        if (size == 0) {
            return new byte[0];
        }
        NativeArray array = (NativeArray)rgbAtr.getNativeObject((NativeStruct)this);
        return array.getByteArray(0, size);
    }

    public int getATRSize() {
        int size = (int)cbAtr.getCLong((NativeStruct)this, 0);
        return size < 0 ? 0 : size;
    }

    public int getCurrentState() {
        return (int)dwCurrentState.getCLong((NativeStruct)this, 0);
    }

    public int getEventState() {
        return (int)dwEventState.getCLong((NativeStruct)this, 0);
    }

    public INativeType getNativeType() {
        return META;
    }

    public String getReader() {
        return ((NativeString)szReader.getValue((NativeStruct)this)).stringValue();
    }

    public void setATR(byte[] newAtr) {
        if (newAtr == null) {
            cbAtr.setInt((NativeStruct)this, 0, 0);
            return;
        }
        int length = newAtr.length;
        if (length > 36) {
            throw new IllegalArgumentException("ATR cannot be longer than 36 bytes");
        }
        cbAtr.setInt((NativeStruct)this, 0, newAtr.length);
        NativeArray array = (NativeArray)rgbAtr.getNativeObject((NativeStruct)this);
        array.setByteArray(0, newAtr, 0, length);
    }

    public void setCurrentState(int state) {
        dwCurrentState.setValue((NativeStruct)this, (Object)state);
    }

    public void setEventState(int state) {
        dwEventState.setValue((NativeStruct)this, (Object)state);
    }

    public void setReader(NativeString name) {
        szReader.setValue((NativeStruct)this, (Object)name);
    }

    static {
        szReader = META.declare("szReader", NativeString.META.Ref());
        META.declare("pvUserData", NativeVoid.META.Ref());
        dwCurrentState = META.declare("dwCurrentState", (INativeType)NativePcscDword.META);
        dwEventState = META.declare("dwEventState", (INativeType)NativePcscDword.META);
        cbAtr = META.declare("cbAtr", (INativeType)NativePcscDword.META);
        rgbAtr = META.declare("rgbAtr", NativeByte.META.Array(36));
    }

    public static class MetaClass
    extends NativeStructType {
        protected MetaClass(Class<SCARD_READERSTATE> instanceClass) {
            super(instanceClass);
        }

        public INativeObject createNative(INativeHandle handle) {
            return new SCARD_READERSTATE(handle);
        }
    }
}

