/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.pcsc.nativec;

import de.intarsys.nativec.api.INativeFunction;
import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.INativeLibrary;
import de.intarsys.nativec.api.NativeInterface;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.NativeBuffer;
import de.intarsys.nativec.type.NativeLongLP64;
import de.intarsys.nativec.type.NativeLongLP64Type;
import de.intarsys.nativec.type.NativeString;
import de.intarsys.nativec.type.NativeVoid;
import de.intarsys.security.smartcard.pcsc.nativec.NativePcscDword;
import de.intarsys.security.smartcard.pcsc.nativec.NativePcscDwordType;
import de.intarsys.security.smartcard.pcsc.nativec.SCARDCONTEXT;
import de.intarsys.security.smartcard.pcsc.nativec.SCARDHANDLE;
import de.intarsys.security.smartcard.pcsc.nativec._IPCSC;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.system.SystemTools;
import java.io.File;

public class _PCSC
implements _IPCSC {
    public static final String SYSTEM_DEFAULT_LIBRARY = "";
    private static final String SCARD_BEGIN_TRANSACTION = "SCardBeginTransaction";
    private static final String SCARD_CANCEL = "SCardCancel";
    private static final String SCARD_CONNECT = "SCardConnect";
    private static final String SCARD_RECONNECT = "SCardReconnect";
    private static final String SCARD_CONTROL = "SCardControl";
    private static final String SCARD_DISCONNECT = "SCardDisconnect";
    private static final String SCARD_END_TRANSACTION = "SCardEndTransaction";
    private static final String SCARD_ESTABLISH_CONTEXT = "SCardEstablishContext";
    private static final String SCARD_FREE_MEMORY = "SCardFreeMemory";
    private static final String SCARD_GET_ATTRIB = "SCardGetAttrib";
    private static final String SCARD_GET_STATUS_CHANGE = "SCardGetStatusChange";
    private static final String SCARD_LIST_READERS = "SCardListReaders";
    private static final String SCARD_RELEASE_CONTEXT = "SCardReleaseContext";
    private static final String SCARD_STATUS = "SCardStatus";
    private static final String SCARD_TRANSMIT = "SCardTransmit";
    private static final String SCARD_PCI_RAW_NAME = "g_rgSCardRawPci";
    private static final String SCARD_PCI_T0_NAME = "g_rgSCardT0Pci";
    private static final String SCARD_PCI_T1_NAME = "g_rgSCardT1Pci";
    private INativeLibrary lib;
    private String pcscLibraryPath;
    private INativeHandle scardPciRaw;
    private INativeHandle scardPciT0;
    private INativeHandle scardPciT1;
    private INativeFunction callSCardBeginTransaction;
    private INativeFunction callSCardCancel;
    private INativeFunction callSCardConnect;
    private INativeFunction callSCardReconnect;
    private INativeFunction callSCardControl;
    private INativeFunction callSCardDisconnect;
    private INativeFunction callSCardEndTransaction;
    private INativeFunction callSCardEstablishContext;
    private INativeFunction callSCardFreeMemory;
    private INativeFunction callSCardGetAttrib;
    private INativeFunction callSCardGetStatusChange;
    private INativeFunction callSCardListReaders;
    private INativeFunction callSCardReleaseContext;
    private INativeFunction callSCardTransmit;
    private INativeFunction callSCardStatus;

    public _PCSC(String pcscLibrary) {
        String defaultLibrary = SystemTools.isWindows() ? "winscard" : "pcsclite";
        if (StringTools.isEmpty((String)pcscLibrary)) {
            this.pcscLibraryPath = SystemTools.isMac() ? "PCSC" : SystemTools.mapLibraryName((String)defaultLibrary, (String)"1");
        } else {
            File file = new File(pcscLibrary);
            if (file.isDirectory()) {
                file = new File(file, SystemTools.mapLibraryName((String)defaultLibrary, (String)"1"));
                this.pcscLibraryPath = file.getAbsolutePath();
            } else {
                this.pcscLibraryPath = pcscLibrary;
            }
        }
        this.init();
    }

    @Override
    public INativeHandle getSCARD_PCI_RAW() {
        return this.scardPciRaw;
    }

    @Override
    public INativeHandle getSCARD_PCI_T0() {
        return this.scardPciT0;
    }

    @Override
    public INativeHandle getSCARD_PCI_T1() {
        return this.scardPciT1;
    }

    private void init() {
        this.lib = NativeInterface.get().createLibrary(this.pcscLibraryPath);
        if (SystemTools.isWindows()) {
            this.callSCardConnect = this.lib.getFunction("SCardConnectA");
            this.callSCardGetStatusChange = this.lib.getFunction("SCardGetStatusChangeA");
            this.callSCardListReaders = this.lib.getFunction("SCardListReadersA");
            this.callSCardStatus = this.lib.getFunction("SCardStatusA");
        } else {
            this.callSCardConnect = this.lib.getFunction(SCARD_CONNECT);
            this.callSCardGetStatusChange = this.lib.getFunction(SCARD_GET_STATUS_CHANGE);
            this.callSCardListReaders = this.lib.getFunction(SCARD_LIST_READERS);
            this.callSCardStatus = this.lib.getFunction(SCARD_STATUS);
        }
        this.callSCardReconnect = this.lib.getFunction(SCARD_RECONNECT);
        this.callSCardBeginTransaction = this.lib.getFunction(SCARD_BEGIN_TRANSACTION);
        this.callSCardCancel = this.lib.getFunction(SCARD_CANCEL);
        if (SystemTools.isMac()) {
            try {
                this.callSCardControl = this.lib.getFunction("SCardControl132");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        } else {
            this.callSCardControl = this.lib.getFunction(SCARD_CONTROL);
            this.callSCardFreeMemory = this.lib.getFunction(SCARD_FREE_MEMORY);
        }
        this.callSCardDisconnect = this.lib.getFunction(SCARD_DISCONNECT);
        this.callSCardEndTransaction = this.lib.getFunction(SCARD_END_TRANSACTION);
        this.callSCardEstablishContext = this.lib.getFunction(SCARD_ESTABLISH_CONTEXT);
        this.callSCardGetAttrib = this.lib.getFunction(SCARD_GET_ATTRIB);
        this.callSCardReleaseContext = this.lib.getFunction(SCARD_RELEASE_CONTEXT);
        this.callSCardTransmit = this.lib.getFunction(SCARD_TRANSMIT);
        this.scardPciT0 = this.lib.getGlobal(SCARD_PCI_T0_NAME);
        this.scardPciT1 = this.lib.getGlobal(SCARD_PCI_T1_NAME);
        this.scardPciRaw = this.lib.getGlobal(SCARD_PCI_RAW_NAME);
    }

    @Override
    public int SCardBeginTransaction(SCARDHANDLE hCard) {
        Number rc = (Number)this.callSCardBeginTransaction.invoke(NativePcscDwordType.primitiveClass(), new Object[]{NativeLongLP64Type.coerce((Number)hCard.longValue())});
        return rc.intValue();
    }

    @Override
    public int SCardCancel(SCARDCONTEXT hContext) {
        Number rc = (Number)this.callSCardCancel.invoke(NativePcscDwordType.primitiveClass(), new Object[]{NativeLongLP64Type.coerce((Number)hContext.longValue())});
        return rc.intValue();
    }

    @Override
    public int SCardConnect(SCARDCONTEXT hContext, NativeString szReader, long dwShareMode, long dwPreferredProtocols, NativeLongLP64 phCard, NativePcscDword pdwActiveProtocol) {
        Number rc = (Number)this.callSCardConnect.invoke(NativePcscDwordType.primitiveClass(), new Object[]{NativeLongLP64Type.coerce((Number)hContext.longValue()), szReader, NativePcscDwordType.coerce(dwShareMode), NativePcscDwordType.coerce(dwPreferredProtocols), phCard, pdwActiveProtocol});
        return rc.intValue();
    }

    @Override
    public int SCardControl(SCARDHANDLE hCard, long dwControlCode, NativeBuffer pbSendBuffer, long cbSendLength, NativeBuffer pbRecvBuffer, long cbRecvLength, NativePcscDword lpBytesReturned) {
        if (this.callSCardControl == null) {
            lpBytesReturned.setValue(0L);
            return 0;
        }
        Number rc = (Number)this.callSCardControl.invoke(NativePcscDwordType.primitiveClass(), new Object[]{NativeLongLP64Type.coerce((Number)hCard.longValue()), NativePcscDwordType.coerce(dwControlCode), pbSendBuffer, NativePcscDwordType.coerce(cbSendLength), pbRecvBuffer, NativePcscDwordType.coerce(cbRecvLength), lpBytesReturned});
        return rc.intValue();
    }

    @Override
    public int SCardDisconnect(SCARDHANDLE hCard, long dwDisposition) {
        Number rc = (Number)this.callSCardDisconnect.invoke(NativePcscDwordType.primitiveClass(), new Object[]{NativeLongLP64Type.coerce((Number)hCard.longValue()), NativePcscDwordType.coerce(dwDisposition)});
        return rc.intValue();
    }

    @Override
    public int SCardEndTransaction(SCARDHANDLE hCard, long dwDisposition) {
        Number rc = (Number)this.callSCardEndTransaction.invoke(NativePcscDwordType.primitiveClass(), new Object[]{NativeLongLP64Type.coerce((Number)hCard.longValue()), NativePcscDwordType.coerce(dwDisposition)});
        return rc.intValue();
    }

    @Override
    public int SCardEstablishContext(long dwScope, NativeLongLP64 phContext) {
        Number rc = (Number)this.callSCardEstablishContext.invoke(NativePcscDwordType.primitiveClass(), new Object[]{NativePcscDwordType.coerce(dwScope), NativeVoid.NULL, NativeVoid.NULL, phContext});
        return rc.intValue();
    }

    @Override
    public int SCardFreeMemory(SCARDCONTEXT hContext, NativeVoid pvMem) {
        Number rc = (Number)this.callSCardFreeMemory.invoke(NativePcscDwordType.primitiveClass(), new Object[]{NativeLongLP64Type.coerce((Number)hContext.longValue()), pvMem});
        return rc.intValue();
    }

    @Override
    public int SCardGetAttrib(SCARDHANDLE hCard, long dwAttrId, NativeBuffer pbAttr, NativePcscDword pcbAttrLength) {
        Number rc = (Number)this.callSCardGetAttrib.invoke(NativePcscDwordType.primitiveClass(), new Object[]{NativeLongLP64Type.coerce((Number)hCard.longValue()), NativePcscDwordType.coerce(dwAttrId), pbAttr, pcbAttrLength});
        return rc.intValue();
    }

    @Override
    public int SCardGetStatusChange(SCARDCONTEXT hContext, long dwTimeout, INativeObject rgReaderStates, long cReaders) {
        Number rc = (Number)this.callSCardGetStatusChange.invoke(NativePcscDwordType.primitiveClass(), new Object[]{NativeLongLP64Type.coerce((Number)hContext.longValue()), NativePcscDwordType.coerce(dwTimeout), rgReaderStates, NativePcscDwordType.coerce(cReaders)});
        return rc.intValue();
    }

    @Override
    public int SCardListReaders(SCARDCONTEXT hContext, NativeString mszGroups, INativeObject mszReaders, NativePcscDword pcchReaders) {
        Number rc = (Number)this.callSCardListReaders.invoke(NativePcscDwordType.primitiveClass(), new Object[]{NativeLongLP64Type.coerce((Number)hContext.longValue()), mszGroups, mszReaders, pcchReaders});
        return rc.intValue();
    }

    @Override
    public int SCardReconnect(SCARDHANDLE hCard, long dwShareMode, long dwPreferredProtocols, long dwInitialization, NativePcscDword pdwActiveProtocol) {
        Number rc = (Number)this.callSCardReconnect.invoke(NativePcscDwordType.primitiveClass(), new Object[]{NativeLongLP64Type.coerce((Number)hCard.longValue()), NativePcscDwordType.coerce(dwShareMode), NativePcscDwordType.coerce(dwPreferredProtocols), NativePcscDwordType.coerce(dwInitialization), pdwActiveProtocol});
        return rc.intValue();
    }

    @Override
    public int SCardReleaseContext(SCARDCONTEXT hContext) {
        Number rc = (Number)this.callSCardReleaseContext.invoke(NativePcscDwordType.primitiveClass(), new Object[]{NativeLongLP64Type.coerce((Number)hContext.longValue())});
        return rc.intValue();
    }

    @Override
    public int SCardStatus(SCARDHANDLE hCard, INativeObject szReaderName, NativePcscDword pcchReaderLen, NativePcscDword pdwState, NativePcscDword pdwProtocol, NativeBuffer pbAtr, NativePcscDword pcbAtrLen) {
        Number rc = (Number)this.callSCardStatus.invoke(NativePcscDwordType.primitiveClass(), new Object[]{NativeLongLP64Type.coerce((Number)hCard.longValue()), szReaderName, pcchReaderLen, pdwState, pdwProtocol, pbAtr, pcbAtrLen});
        return rc.intValue();
    }

    @Override
    public int SCardTransmit(SCARDHANDLE hCard, INativeHandle pioSendPci, INativeObject pbSendBuffer, long cbSendLength, INativeObject pioRecvPci, NativeBuffer pbRecvBuffer, NativePcscDword pcbRecvLength) {
        Number rc = (Number)this.callSCardTransmit.invoke(NativePcscDwordType.primitiveClass(), new Object[]{NativeLongLP64Type.coerce((Number)hCard.longValue()), pioSendPci, pbSendBuffer, NativePcscDwordType.coerce(cbSendLength), pioRecvPci, pbRecvBuffer, pcbRecvLength});
        return rc.intValue();
    }
}

