/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.audit;

import de.intarsys.cloudsuite.gears.audit.IAuditDao;
import de.intarsys.cloudsuite.gears.audit.RecAuditEntry;
import de.intarsys.cloudsuite.gears.audit.RecAuditSession;
import de.intarsys.security.audit.v2.core.Audit;
import de.intarsys.security.audit.v2.core.AuditException;
import de.intarsys.security.audit.v2.core.AuditValidator;
import de.intarsys.security.audit.v2.core.IAuditEntry;
import de.intarsys.security.audit.v2.core.IAuditSession;
import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.servicelocator.ServiceLocator;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.List;
import java.util.function.Consumer;

@SingletonProvider
public class Auditor
implements IAuditSession {
    private IAuditSession auditSession;
    private IAuditDao auditDao;
    private Audit audit;
    private String name = "auditor";
    private int sessionId;

    public static Auditor get() {
        return (Auditor)ServiceLocator.get().get(Auditor.class);
    }

    public IAuditEntry close() throws AuditException {
        return this.auditSession.close();
    }

    @PreDestroy
    public void destroy() {
        try {
            if (this.auditSession != null) {
                this.auditSession.close();
                this.auditSession.sign();
            }
        }
        catch (AuditException e) {
            throw new IllegalArgumentException("auditor can not be destroyed", e);
        }
    }

    public Audit getAudit() {
        return this.audit;
    }

    public IAuditDao getAuditDao() {
        return this.auditDao;
    }

    public List<RecAuditEntry> getAuditRecords(int sessionId) throws Exception {
        List<RecAuditEntry> entries = this.getAuditDao().selectAuditRecord(sessionId);
        AuditValidator validator = new AuditValidator(this.getAudit());
        for (RecAuditEntry entry : entries) {
            try {
                validator.accept((IAuditEntry)entry);
            }
            catch (Exception e) {
                entry.setError(e.getMessage());
            }
        }
        return entries;
    }

    public List<RecAuditSession> getAuditSessions() throws Exception {
        List<RecAuditSession> entries = this.getAuditDao().selectAuditSession(null);
        return entries;
    }

    public String getName() {
        return this.name;
    }

    protected int getSessionId() {
        return this.sessionId;
    }

    @PostConstruct
    public void init() {
        if (this.audit == null) {
            throw new IllegalArgumentException("audit required");
        }
        try {
            this.auditSession = this.audit.createSession();
            this.sessionId = this.getAuditDao().insert(this.auditSession, this.getName());
            this.auditSession.onEntry(entry -> this.getAuditDao().insert(new RecAuditEntry((IAuditEntry)entry), this.getSessionId()));
            this.auditSession.open();
            this.auditSession.sign();
        }
        catch (AuditException e) {
            throw new IllegalArgumentException("auditor can not be initialized", e);
        }
        Audit.set((IAuditSession)this);
    }

    public IAuditEntry log(String message) throws AuditException {
        return this.auditSession.log(message);
    }

    public void onEntry(Consumer<IAuditEntry> consumer) {
        this.auditSession.onEntry(consumer);
    }

    public IAuditEntry open() throws AuditException {
        return this.auditSession.open();
    }

    public void setAudit(Audit audit) {
        this.audit = audit;
    }

    public void setAuditDao(IAuditDao auditDao) {
        this.auditDao = auditDao;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IAuditEntry sign() throws AuditException {
        return this.auditSession.sign();
    }
}

