/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.audit;

import de.intarsys.cloudsuite.gears.audit.IAuditDao;
import de.intarsys.cloudsuite.gears.audit.RecAuditEntry;
import de.intarsys.cloudsuite.gears.audit.RecAuditSession;
import de.intarsys.security.audit.v2.core.IAuditSession;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class JdbcAuditDao
extends JdbcDaoSupport
implements IAuditDao {
    private static final String FIELD_ID = "c_id";

    @Override
    public int insert(IAuditSession session, final String name) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        final String sql = "insert into t_audit_session (c_name) values (?)";
        this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement pst = con.prepareStatement(sql, new String[]{JdbcAuditDao.FIELD_ID});
                pst.setString(1, name);
                return pst;
            }
        }, (KeyHolder)keyHolder);
        return keyHolder.getKey().intValue();
    }

    @Override
    public void insert(final RecAuditEntry entry, final int sessionId) {
        final String sql = "insert into t_audit_entry (fk_audit_session, c_command, c_tick, c_sequence_number, c_message, c_seal) values (?, ?, ?, ?, ?, ?)";
        this.getJdbcTemplate().update(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement pst = con.prepareStatement(sql);
                pst.setInt(1, sessionId);
                pst.setString(2, "" + entry.getAuditCommand());
                pst.setLong(3, entry.getAuditTick());
                pst.setInt(4, entry.getAuditSequenceNumber());
                pst.setString(5, entry.getAuditMessage());
                pst.setBytes(6, entry.getAuditSeal());
                return pst;
            }
        });
    }

    @Override
    public List<RecAuditEntry> selectAuditRecord(final int sessionId) {
        final String sql = "select * from t_audit_entry where fk_audit_session = ? order by c_sequence_number";
        return this.getJdbcTemplate().query(new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement pst = con.prepareStatement(sql);
                pst.setInt(1, sessionId);
                return pst;
            }
        }, (RowMapper)new RowMapper<RecAuditEntry>(){

            public RecAuditEntry mapRow(ResultSet rs, int rowNum) throws SQLException {
                RecAuditEntry result = new RecAuditEntry();
                result.setAuditCommand(rs.getString("c_command").charAt(0));
                result.setAuditMessage(rs.getString("c_message"));
                result.setAuditSeal(rs.getBytes("c_seal"));
                result.setAuditSequenceNumber(rs.getInt("c_sequence_number"));
                result.setAuditTick(rs.getLong("c_tick"));
                return result;
            }
        });
    }

    @Override
    public List<RecAuditSession> selectAuditSession(Object query) {
        String sql = "select * from t_audit_session order by c_created";
        return this.getJdbcTemplate().query(sql, (RowMapper)new RowMapper<RecAuditSession>(){

            public RecAuditSession mapRow(ResultSet rs, int rowNum) throws SQLException {
                RecAuditSession result = new RecAuditSession();
                result.setId(rs.getInt(JdbcAuditDao.FIELD_ID));
                result.setCreated(rs.getTimestamp("c_created"));
                result.setName(rs.getString("c_name"));
                return result;
            }
        });
    }
}

