/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.audit.crypto;

import de.intarsys.asn1.cms.SignerIdentifier;
import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.common.RSASSAPSSParams;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.asn1.x509.Certificate;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.PpkTools;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.IAuthenticatedApplication;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.audit.v2.core.AuditException;
import de.intarsys.security.audit.v2.core.IAuditSignatureProvider;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.keystore.IKeyStore;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFactory;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.security.device.keystore.device.KeystoreDeviceProvider;
import de.intarsys.security.oid.OIDTools;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.ToBeSignedData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.driver.ConversationDriver;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ClassLoaderResourceLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;

public class FooKeyStoreSigner
implements IAuditSignatureProvider {
    private static final String RESULT_SIGNATURE_ALGORITHM = "signatureAlgorithm";
    private static final String RESULT_SIGNATURE = "signature";
    private IByteProvider keyStoreKeyProvider;
    private IByteProvider keyKeyProvider;
    private KeystoreDevice device;
    private Secret keySecret;
    private String keyStoreFileName;
    private IX509PublicKeyCertificate signerCertificate;

    protected byte[] decode(String value) throws IOException {
        return Base64.decode((String)value);
    }

    protected ASN1Based deriveDigestAlgorithm(ISigner signer, IDigest digest) {
        String documentDigestOid = DigestAlgorithm.lookupOID((String)digest.getAlgorithmName());
        return AlgorithmIdentifier.create((String)documentDigestOid);
    }

    protected AlgorithmIdentifier deriveSignatureAlgorithm(ISigner signer, IDigest digest) throws SecurityApplicationException {
        AlgorithmParameterSpec encAlgParams = signer.getAlgorithmParameterSpec();
        if (encAlgParams instanceof PSSParameterSpec) {
            return this.deriveSignatureAlgorithmPSS(signer, digest, (PSSParameterSpec)encAlgParams);
        }
        return this.deriveSignatureAlgorithmDefault(signer, digest);
    }

    protected AlgorithmIdentifier deriveSignatureAlgorithmDefault(ISigner signer, IDigest digest) throws SecurityApplicationException {
        String encAlgName = signer.getEncryptionAlgorithmName();
        String signatureAlgoId = SignatureAlgorithm.createOID((String)encAlgName, (String)digest.getAlgorithmName(), null);
        return AlgorithmIdentifier.create((String)signatureAlgoId);
    }

    protected AlgorithmIdentifier deriveSignatureAlgorithmPSS(ISigner signer, IDigest digest, PSSParameterSpec pssParams) throws SecurityApplicationException {
        AlgorithmIdentifier signatureAlgorithm = AlgorithmIdentifier.create((String)"1.2.840.113549.1.1.10");
        RSASSAPSSParams signatureAlgorithmParameters = (RSASSAPSSParams)RSASSAPSSParams.FACTORY.createNew();
        String hashAlgorithmOid = DigestAlgorithm.lookupOID((String)pssParams.getDigestAlgorithm());
        signatureAlgorithmParameters.setHashAlgorithm(AlgorithmIdentifier.create((String)hashAlgorithmOid));
        String mgfName = pssParams.getMGFAlgorithm();
        String mgfOid = OIDTools.getMaskGenerationAlgorithmOID((String)mgfName);
        if (mgfOid == null) {
            throw new SecurityApplicationException("unsupported mask generation function: " + mgfName);
        }
        AlgorithmIdentifier mgfAlgorithm = AlgorithmIdentifier.create((String)mgfOid);
        switch (mgfOid) {
            case "1.2.840.113549.1.1.8": {
                MGF1ParameterSpec mgfParameters = (MGF1ParameterSpec)pssParams.getMGFParameters();
                String mfgHashAlgorithmOid = DigestAlgorithm.lookupOID((String)mgfParameters.getDigestAlgorithm());
                mgfAlgorithm.setParameters((ASN1Encodable)AlgorithmIdentifier.create((String)mfgHashAlgorithmOid));
            }
        }
        signatureAlgorithmParameters.setMaskGenAlgorithm(mgfAlgorithm);
        signatureAlgorithmParameters.setSaltLength(pssParams.getSaltLength());
        signatureAlgorithmParameters.setTrailerField(pssParams.getTrailerField());
        signatureAlgorithm.setParameters((ASN1Encodable)signatureAlgorithmParameters);
        return signatureAlgorithm;
    }

    protected SignerIdentifier deriveSignatureIdentifier(ISigner signer, IDigest digest) throws CertificateEncodingException, IOException {
        SignerIdentifier signerId = (SignerIdentifier)SignerIdentifier.FACTORY.createNew();
        Certificate signerCert = this.recodeCertificate(signer.getCertificatePath()[0]);
        signerId.setIssuerAndSerialNumber(signerCert.getIssuerAndSerialNumber());
        return signerId;
    }

    protected String encode(byte[] value) {
        return new String(Base64.encode((byte[])value));
    }

    protected KeystoreDevice getDevice() {
        return this.device;
    }

    public IByteProvider getKeyKeyProvider() {
        return this.keyKeyProvider;
    }

    protected Secret getKeySecret() {
        return this.keySecret;
    }

    public String getKeyStoreFileName() {
        return this.keyStoreFileName;
    }

    public IByteProvider getKeyStoreKeyProvider() {
        return this.keyStoreKeyProvider;
    }

    protected IX509PublicKeyCertificate getSignerCertificate() {
        return this.signerCertificate;
    }

    @PostConstruct
    public void init() {
        IKeyStore facade;
        try {
            FileLocator locator = new FileLocator(this.getKeyStoreFileName());
            if (!locator.exists()) {
                String tempName = "cloudsuite/config/cloud-suite-gears-sign.p12";
                locator = new ClassLoaderResourceLocator(this.getClass().getClassLoader(), tempName);
            }
            facade = KeyStoreFactory.get().create((ILocator)locator);
            Secret keyStoreSecret = Secret.hide((byte[])this.getKeyStoreKeyProvider().getBytes());
            facade.load(keyStoreSecret);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot load key store", e);
        }
        ICertificateProvider provider = facade.getCertificateProvider();
        X509CertificateSelector selector = new X509CertificateSelector();
        selector.setHasPrivateKey(Boolean.valueOf(true));
        Iterator i = provider.lookupCertificates((IX509CertificateFilter)selector);
        if (!i.hasNext()) {
            throw new IllegalArgumentException("no key loaded");
        }
        this.signerCertificate = (IX509PublicKeyCertificate)i.next();
        try {
            this.keySecret = Secret.hide((byte[])this.getKeyKeyProvider().getBytes());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot load private key secret", e);
        }
        try {
            this.device = (KeystoreDevice)DeviceTools.getDefaultDevice(KeystoreDeviceProvider.class);
        }
        catch (ObjectCreationException e) {
            throw new IllegalArgumentException("cannot create signature device", e);
        }
    }

    private Certificate recodeCertificate(IX509PublicKeyCertificate cert) throws CertificateEncodingException, IOException {
        return (Certificate)ASN1BasedTools.create((ASN1Based.Factory)Certificate.FACTORY, (byte[])cert.getEncoded());
    }

    protected void setDevice(KeystoreDevice device) {
        this.device = device;
    }

    public void setKeyKeyProvider(IByteProvider keyKeyProvider) {
        this.keyKeyProvider = keyKeyProvider;
    }

    protected void setKeySecret(Secret keySecret) {
        this.keySecret = keySecret;
    }

    public void setKeyStoreFileName(String value) {
        this.keyStoreFileName = value;
    }

    public void setKeyStoreKeyProvider(IByteProvider value) {
        this.keyStoreKeyProvider = value;
    }

    protected void setSignerCertificate(IX509PublicKeyCertificate signerCertificate) {
        this.signerCertificate = signerCertificate;
    }

    public Map<String, Object> sign(IDigest digest) throws AuditException {
        try {
            Args args = Args.create();
            args.put("signerIdentifier", (Object)this.getSignerCertificate());
            args.put("signerPassword", (Object)this.getKeySecret());
            ISigner signer = (ISigner)this.getDevice().createApplication(ISigner.class.getName(), (IArgs)args);
            ((IAuthenticatedApplication)signer).authenticate().get();
            IConversation conversation = signer.sign((IToBeSignedData)ToBeSignedData.create((IDigest)digest));
            byte[] signature = ((ISignatureData)ConversationDriver.get().get(conversation)).getEncodedSignature();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(RESULT_SIGNATURE_ALGORITHM, this.encode(this.deriveSignatureAlgorithm(signer, digest).getDEREncoded()));
            result.put(RESULT_SIGNATURE, this.encode(signature));
            return result;
        }
        catch (Exception e) {
            throw new AuditException((Throwable)e);
        }
    }

    public void validate(Map<String, Object> signatureParams, IDigest digest) throws AuditException {
        String signature = (String)signatureParams.get(RESULT_SIGNATURE);
        try {
            if (!PpkTools.validate((byte[])this.decode(signature), (PublicKey)this.signerCertificate.getPublicKey(), null, (byte[])digest.getEncoded())) {
                throw new AuditException("signature invalid");
            }
        }
        catch (IOException e) {
            throw new AuditException("error decoding signature");
        }
    }
}

