/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.audit.crypto;

import de.intarsys.security.audit.v2.core.AuditException;
import de.intarsys.security.audit.v2.core.IAuditSessionKeyCodec;
import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.crypto.api.IKeyDerivationFunction;
import de.intarsys.tools.encoding.Base64;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class KdfBasedSessionKeyCodec
implements IAuditSessionKeyCodec {
    private static final int KEY_LENGTH = 16;
    public static final String PARAM_VALUE = "value";
    public static final String PARAM_KDFINPUT = "kdfInput";
    public static final String PARAM_TYPE = "type";
    private static final int IV_LENGTH = 16;
    public static final String ENCRYPTION_ALGORITHM = "AES";
    public static final String ENCRYPTION_ALGORITHM_ID = "AES/CBC/PKCS5Padding";
    private IByteProvider inputProvider;
    private IKeyDerivationFunction kdf;

    protected Cipher createDecipher(SecretKey key) throws GeneralSecurityException {
        byte[] iv = new byte[16];
        Arrays.fill(iv, (byte)0);
        IvParameterSpec ips = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM_ID);
        cipher.init(2, (Key)key, ips);
        return cipher;
    }

    protected Cipher createEncipher(SecretKey key) throws GeneralSecurityException {
        byte[] iv = new byte[16];
        Arrays.fill(iv, (byte)0);
        IvParameterSpec ips = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM_ID);
        cipher.init(1, (Key)key, ips);
        return cipher;
    }

    public byte[] createSessionKey(Map params) throws AuditException {
        byte[] value;
        byte[] kdfInput;
        String type = (String)params.get(PARAM_TYPE);
        if (!this.getClass().getName().equals(type)) {
            throw new AuditException("cannot create session key, unsupported key type");
        }
        String inputString = (String)params.get(PARAM_KDFINPUT);
        try {
            kdfInput = this.decode(inputString);
        }
        catch (IOException e) {
            throw new AuditException("cannot create session key, key encoding failure", (Throwable)e);
        }
        String valueString = (String)params.get(PARAM_VALUE);
        try {
            value = this.decode(valueString);
        }
        catch (IOException e) {
            throw new AuditException("cannot create session key, key encoding failure", (Throwable)e);
        }
        IKeyDerivationFunction keyProvider = this.getKdf();
        try {
            byte[] keyMaterial = keyProvider.derive(kdfInput, 16);
            SecretKeySpec key = new SecretKeySpec(keyMaterial, ENCRYPTION_ALGORITHM);
            Cipher decipher = this.createDecipher(key);
            return decipher.doFinal(value);
        }
        catch (Exception e) {
            throw new AuditException("cannot create session key, decipher failure", (Throwable)e);
        }
    }

    public Map createSessionKeyParams(byte[] value) throws AuditException {
        byte[] kdfInput;
        IKeyDerivationFunction keyProvider = this.getKdf();
        try {
            kdfInput = this.getInputProvider().getBytes();
        }
        catch (IOException e) {
            throw new AuditException("cannot create session key params, kdf input creation failed", (Throwable)e);
        }
        if (kdfInput == null) {
            throw new IllegalArgumentException("kdf input is required for key derivation");
        }
        try {
            byte[] keyMaterial = keyProvider.derive(kdfInput, 16);
            SecretKeySpec key = new SecretKeySpec(keyMaterial, ENCRYPTION_ALGORITHM);
            Cipher encipher = this.createEncipher(key);
            byte[] encoded = encipher.doFinal(value);
            HashMap<String, String> keyParams = new HashMap<String, String>();
            keyParams.put(PARAM_TYPE, this.getClass().getName());
            keyParams.put(PARAM_KDFINPUT, this.encode(kdfInput));
            keyParams.put(PARAM_VALUE, this.encode(encoded));
            return keyParams;
        }
        catch (Exception e) {
            throw new AuditException("cannot create session key, encipher failure", (Throwable)e);
        }
    }

    protected byte[] decode(String value) throws IOException {
        return Base64.decode((String)value);
    }

    protected String encode(byte[] value) {
        return new String(Base64.encode((byte[])value));
    }

    public IByteProvider getInputProvider() {
        return this.inputProvider;
    }

    public IKeyDerivationFunction getKdf() {
        return this.kdf;
    }

    @PostConstruct
    public void init() {
        if (this.inputProvider == null) {
            throw new IllegalArgumentException("kdf input provider is required for key derivation");
        }
    }

    public void setInputProvider(IByteProvider provider) {
        this.inputProvider = provider;
    }

    public void setKdf(IKeyDerivationFunction keyDerivationFunction) {
        this.kdf = keyDerivationFunction;
    }
}

