/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.audit.crypto;

import de.intarsys.security.audit.v2.core.AuditException;
import de.intarsys.security.audit.v2.core.IAuditSessionKeyCodec;
import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.encoding.Base64;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class StaticSessionKeyCodec
implements IAuditSessionKeyCodec {
    public static final String PARAM_VALUE = "value";
    public static final String PARAM_TYPE = "type";
    private static final int IV_LENGTH = 16;
    public static final String ENCRYPTION_ALGORITHM = "AES";
    public static final String ENCRYPTION_ALGORITHM_ID = "AES/CBC/PKCS5Padding";
    private IByteProvider keyProvider;

    protected Cipher createDecipher(SecretKey key) throws GeneralSecurityException {
        byte[] iv = new byte[16];
        Arrays.fill(iv, (byte)0);
        IvParameterSpec ips = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM_ID);
        cipher.init(2, (Key)key, ips);
        return cipher;
    }

    protected Cipher createEncipher(SecretKey key) throws GeneralSecurityException {
        byte[] iv = new byte[16];
        Arrays.fill(iv, (byte)0);
        IvParameterSpec ips = new IvParameterSpec(iv);
        Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM_ID);
        cipher.init(1, (Key)key, ips);
        return cipher;
    }

    public byte[] createSessionKey(Map params) throws AuditException {
        byte[] value;
        String type = (String)params.get(PARAM_TYPE);
        if (!this.getClass().getName().equals(type)) {
            throw new AuditException("cannot create session key, unsupported key type");
        }
        String valueString = (String)params.get(PARAM_VALUE);
        try {
            value = this.decode(valueString);
        }
        catch (IOException e) {
            throw new AuditException("cannot create session key, key encoding failure", (Throwable)e);
        }
        try {
            byte[] keyBytes = this.keyProvider.getBytes();
            SecretKeySpec key = new SecretKeySpec(keyBytes, ENCRYPTION_ALGORITHM);
            Cipher decipher = this.createDecipher(key);
            return decipher.doFinal(value);
        }
        catch (Exception e) {
            throw new AuditException("cannot create session key, decipher failure", (Throwable)e);
        }
    }

    public Map createSessionKeyParams(byte[] value) throws AuditException {
        try {
            byte[] keyBytes = this.keyProvider.getBytes();
            SecretKeySpec key = new SecretKeySpec(keyBytes, ENCRYPTION_ALGORITHM);
            Cipher encipher = this.createEncipher(key);
            byte[] encoded = encipher.doFinal(value);
            HashMap<String, String> keyParams = new HashMap<String, String>();
            keyParams.put(PARAM_TYPE, this.getClass().getName());
            keyParams.put(PARAM_VALUE, this.encode(encoded));
            return keyParams;
        }
        catch (Exception e) {
            throw new AuditException("cannot create session key, encipher failure", (Throwable)e);
        }
    }

    protected byte[] decode(String value) throws IOException {
        return Base64.decode((String)value);
    }

    protected String encode(byte[] value) {
        return new String(Base64.encode((byte[])value));
    }

    public IByteProvider getKeyProvider() {
        return this.keyProvider;
    }

    @PostConstruct
    public void init() {
    }

    public void setKeyProvider(IByteProvider keyProvider) {
        this.keyProvider = keyProvider;
    }
}

