/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signme.activity;

import de.bdr.signme.api.v2.ApiSession;
import de.bdr.signme.api.v2.gen.GetIdentityResponse;
import de.bdr.signme.api.v2.gen.Person;
import de.bdr.signme.api.v2.gen.RedirectURLs;
import de.bdr.signme.api.v2.gen.SignerStatus;
import de.intarsys.security.common.CommonSecurityException;
import de.intarsys.security.signme.common.ISignMeLevel;
import de.intarsys.security.signme.common.SignMeSignatureFormat;
import de.intarsys.security.signme.common.SignMeTools;
import de.intarsys.tools.activity.CommonActivity;
import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.net.IUriProvider;
import de.intarsys.tools.string.StringTools;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignMeActivity<R, P extends IActivity<?>>
extends CommonActivity<R, P> {
    private static final Logger Log = LoggerFactory.getLogger(SignMeActivity.class);
    private ISignMeLevel signatureLevel;
    private ApiSession session;
    private String username;
    private String message;
    private SignerStatus signerStatus;
    private IUriProvider redirectUriProvider;
    private String redirectParamName = "state";
    private String redirectParamValue;
    private Person identity;
    private String queryString;

    public static String createInteractionUrl(String url, String query, String username) {
        try {
            if (StringTools.isEmpty((String)url)) {
                return null;
            }
            if (StringTools.isEmpty((String)query)) {
                return url;
            }
            MapResolver resolver = new MapResolver(false);
            resolver.put("username", (Object)URLEncoder.encode(username, "UTF-8"));
            TaggedStringEvaluator evaluator = TaggedStringEvaluator.decorate((IStringEvaluator[])new IStringEvaluator[]{resolver});
            Object expanded = evaluator.evaluate(query, (IArgs)Args.create());
            if (expanded instanceof String && !StringTools.isEmpty((String)((String)expanded))) {
                String separator = ((String)url).indexOf("?") >= 0 ? "&" : "?";
                url = (String)url + separator + expanded;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return url;
    }

    public SignMeActivity() {
    }

    public SignMeActivity(P parent) {
        super(parent);
    }

    protected Person createIdentity() throws CommonSecurityException {
        if (StringTools.isEmpty((String)this.getUsername())) {
            Log.trace("{} createIdentity username empty", (Object)this.getLogLabel());
            return null;
        }
        GetIdentityResponse identity = SignMeTools.signMeGetIdentity(this.getSession(), this.getUsername());
        if (identity == null || identity.getPerson() == null && identity.getOrganization() == null) {
            Log.debug("{} createIdentity {} not found", (Object)this.getLogLabel(), (Object)this.getUsername());
            this.setMessage("Der Benutzer " + this.getUsername() + " ist nicht registriert");
            return null;
        }
        if (identity.getOrganization() != null) {
            Log.debug("{} createIdentity {} is an organization", (Object)this.getLogLabel(), (Object)this.getUsername());
            this.setMessage("'" + this.getUsername() + "' ist eine registrierte Organisation");
            return null;
        }
        Log.debug("{} createIdentity {} found", (Object)this.getLogLabel(), (Object)this.getUsername());
        return identity.getPerson();
    }

    protected String createInteractionUrl(String url) {
        return SignMeActivity.createInteractionUrl(url, this.getQueryString(), this.getUsername());
    }

    protected RedirectURLs createRedirectUrls() {
        if (this.getRedirectUriProvider() == null || this.getRedirectUriProvider().getUri() == null) {
            return null;
        }
        UriBuilder builder = UriBuilder.fromUri((URI)this.getRedirectUriProvider().getUri());
        if (!StringTools.isEmpty((String)this.getRedirectParamValue())) {
            builder.queryParam(this.getRedirectParamName(), new Object[]{this.getRedirectParamValue()});
        }
        return SignMeTools.createRedirectUrls(builder);
    }

    protected SignerStatus createSignerStatus() throws CommonSecurityException {
        if (StringTools.isEmpty((String)this.getUsername())) {
            Log.debug("{} createSignerStatus no username", (Object)this.getLogLabel());
            return null;
        }
        if (this.getSignatureLevel() == null) {
            Log.debug("{} createSignerStatus no signature level", (Object)this.getLogLabel());
            return null;
        }
        SignMeSignatureFormat format = SignMeSignatureFormat.CADES;
        String signatureType = SignMeTools.getSignatureTypeDigest(this.getSignatureLevel(), format);
        Log.debug("{} createSignerStatus user {}, type {}", new Object[]{this.getLogLabel(), this.getUsername(), signatureType});
        return SignMeTools.signMeGetSignerStatus(this.getSession(), this.getUsername(), signatureType);
    }

    protected void ensureValid() {
        if (this.session == null) {
            throw new IllegalStateException("no session");
        }
    }

    public Person getIdentity() throws CommonSecurityException {
        this.ensureValid();
        if (this.identity == null) {
            this.identity = this.createIdentity();
        }
        return this.identity;
    }

    public String getMessage() {
        return this.message;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRedirectParamName() {
        return this.redirectParamName;
    }

    public String getRedirectParamValue() {
        return this.redirectParamValue;
    }

    public IUriProvider getRedirectUriProvider() {
        return this.redirectUriProvider;
    }

    public ApiSession getSession() {
        return this.session;
    }

    public ISignMeLevel getSignatureLevel() {
        return this.signatureLevel;
    }

    public SignerStatus getSignerStatus() throws CommonSecurityException {
        this.ensureValid();
        if (this.signerStatus == null) {
            this.signerStatus = this.createSignerStatus();
        }
        return this.signerStatus;
    }

    public String getUsername() {
        return this.username;
    }

    protected void resetCache() {
        Log.debug("{} resetCache", (Object)this.getLogLabel());
        this.identity = null;
        this.signerStatus = null;
    }

    protected void resetState() {
        Log.debug("{} resetState", (Object)this.getLogLabel());
    }

    public void setIdentity(Person identity) {
        this.identity = identity;
    }

    public void setMessage(String message) {
        Log.debug("{} set message {}", (Object)this.getLogLabel(), (Object)message);
        String oldValue = this.message;
        this.message = message;
        this.triggerChanged("message", oldValue, this.message);
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setRedirectParamName(String value) {
        this.redirectParamName = value;
    }

    public void setRedirectParamValue(String value) {
        this.redirectParamValue = value;
    }

    public void setRedirectUriProvider(IUriProvider value) {
        this.redirectUriProvider = value;
    }

    public void setSession(ApiSession session) {
        this.session = session;
        this.resetState();
    }

    public void setSignatureLevel(ISignMeLevel signatureLevel) {
        this.signatureLevel = signatureLevel;
    }

    public void setSignerStatus(SignerStatus signerStatus) {
        this.signerStatus = signerStatus;
    }

    public void setUsername(String username) {
        if (LangTools.equals((Object)this.getUsername(), (Object)username)) {
            return;
        }
        this.username = username;
        this.resetState();
    }

    public void synchronizeState() {
        this.resetCache();
    }
}

