/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signme.activity;

import de.bdr.signme.api.v2.gen.Person;
import de.bdr.signme.api.v2.gen.RegisterIdentity;
import de.bdr.signme.api.v2.gen.RegisterIdentityResponse;
import de.intarsys.security.common.CommonSecurityException;
import de.intarsys.security.signme.activity.PACKAGE;
import de.intarsys.security.signme.activity.SignMeCommonRegistrationActivity;
import de.intarsys.security.signme.common.SignMeTools;
import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignMeApiRegistrationActivity<P extends IActivity<?>>
extends SignMeCommonRegistrationActivity<P> {
    private static final Logger Log = LoggerFactory.getLogger(SignMeApiRegistrationActivity.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private boolean suppressConfirmationEmail = true;

    public SignMeApiRegistrationActivity() {
    }

    public SignMeApiRegistrationActivity(P parent) {
        super(parent);
    }

    public void doRegistration() {
        Log.trace("{} doRegistration", (Object)this.getLogLabel());
        if (this.validate()) {
            try {
                this.signMeRegisterIdentity();
                this.ok();
                Log.debug("{} doRegistration finished", (Object)this.getLogLabel());
            }
            catch (Exception e) {
                CommonSecurityException tmpEx = SignMeTools.handleError(e);
                String error = ExceptionTools.getMessage((Throwable)tmpEx);
                this.setMessage(Msg.getString("SignMeRegistrationActivity.error.registrationFailed", new Object[]{error}));
                Log.debug("{} doRegistration failed ({})", (Object)this.getLogLabel(), (Object)error);
            }
            this.synchronizeState();
        } else {
            Log.debug("{} doRegistration validation failed {}", (Object)this.getLogLabel(), (Object)this.getMessage());
        }
    }

    public boolean isSuppressConfirmationEmail() {
        return this.suppressConfirmationEmail;
    }

    public void setSuppressConfirmationEmail(boolean suppressConfirmationEmail) {
        this.suppressConfirmationEmail = suppressConfirmationEmail;
    }

    protected RegisterIdentityResponse signMeRegisterIdentity() throws CommonSecurityException {
        try {
            RegisterIdentity registerIdentity = new RegisterIdentity();
            registerIdentity.setSuppressConfirmationEmail(Boolean.valueOf(this.isSuppressConfirmationEmail()));
            Person person = new Person();
            registerIdentity.setPerson(person);
            person.setFamilyNames(this.getProperties().getFamilynames());
            person.setGivenNames(this.getProperties().getGivennames());
            person.setEmailAddress(this.getProperties().getEmail());
            person.setMobilePhoneNumber(this.getProperties().getMobilePhoneNumber());
            person.setUsername(this.getUsername());
            person.setPasswd(this.getProperties().getPassword());
            person.setIndoctrination(Boolean.valueOf(true));
            person.setPreferredLanguage("de");
            return this.getSession().registerIdentity(registerIdentity);
        }
        catch (Exception e) {
            throw SignMeTools.handleError(e);
        }
    }

    @Override
    protected boolean validate() {
        if (!super.validate()) {
            return false;
        }
        if (StringTools.isEmpty((String)this.getUsername())) {
            this.setMessage(Msg.getString("SignMeRegistrationActivity.error.usernameRequired", new Object[0]));
            return false;
        }
        if (StringTools.isEmpty((String)this.getProperties().getPassword())) {
            this.setMessage(Msg.getString("SignMeRegistrationActivity.error.passwordRequired", new Object[0]));
            return false;
        }
        if (StringTools.isEmpty((String)this.getProperties().getFamilynames())) {
            this.setMessage(Msg.getString("SignMeRegistrationActivity.error.familyNameRequired", new Object[0]));
            return false;
        }
        if (StringTools.isEmpty((String)this.getProperties().getGivennames())) {
            this.setMessage(Msg.getString("SignMeRegistrationActivity.error.givenNameRequired", new Object[0]));
            return false;
        }
        if (StringTools.isEmpty((String)this.getProperties().getEmail())) {
            this.setMessage(Msg.getString("SignMeRegistrationActivity.error.emailRequired", new Object[0]));
            return false;
        }
        if (StringTools.isEmpty((String)this.getProperties().getMobilePhoneNumber())) {
            this.setMessage(Msg.getString("SignMeRegistrationActivity.error.mobilePhoneRequired", new Object[0]));
            return false;
        }
        return true;
    }
}

