/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signme.activity;

import de.bdr.signme.api.v2.gen.Person;
import de.intarsys.security.common.CommonSecurityException;
import de.intarsys.security.signme.activity.PACKAGE;
import de.intarsys.security.signme.activity.SignMeActivity;
import de.intarsys.security.signme.common.SignMeTools;
import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.message.IMessageBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SignMeCommonRegistrationActivity<P extends IActivity<?>>
extends SignMeActivity<Void, P> {
    private static final Logger Log = LoggerFactory.getLogger(SignMeCommonRegistrationActivity.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final RegistrationProperties properties = new RegistrationProperties();

    public SignMeCommonRegistrationActivity() {
    }

    public SignMeCommonRegistrationActivity(P parent) {
        super(parent);
    }

    protected void execute() throws Exception {
        super.execute();
        try {
            Person person = this.getIdentity();
            if (person != null) {
                this.ok();
                Log.debug("{} SignMeRegistrationActivity finished", (Object)this.getLogLabel());
            }
        }
        catch (Exception e) {
            CommonSecurityException tmpEx = SignMeTools.handleError(e);
            this.setMessage(Msg.getString("SignMeRegistrationActivity.error.registrationFailed", new Object[]{ExceptionTools.getMessage((Throwable)tmpEx)}));
            Log.debug("{} SignMeRegistrationActivity failed ({})", (Object)this.getLogLabel(), (Object)this.getMessage());
        }
    }

    public RegistrationProperties getProperties() {
        return this.properties;
    }

    protected boolean validate() {
        return true;
    }

    public class RegistrationProperties {
        private String familynames;
        private String givennames;
        private String mobilePhoneNumber;
        private String email;
        private String password;

        public String getEmail() {
            return this.email;
        }

        public String getFamilynames() {
            return this.familynames;
        }

        public String getGivennames() {
            return this.givennames;
        }

        public String getMobilePhoneNumber() {
            return this.mobilePhoneNumber;
        }

        public String getPassword() {
            return this.password;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public void setFamilynames(String familynames) {
            this.familynames = familynames;
        }

        public void setGivennames(String givennames) {
            this.givennames = givennames;
        }

        public void setMobilePhoneNumber(String mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

