/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signme.activity;

import de.bdr.signme.api.v2.ECDSAChallengeSigner;
import de.bdr.signme.api.v2.gen.IdentityVerificationState;
import de.bdr.signme.api.v2.gen.Person;
import de.bdr.signme.api.v2.gen.SignatureProcess;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.common.CommonSecurityException;
import de.intarsys.security.signature.common.SignatureTask;
import de.intarsys.security.signme.activity.PACKAGE;
import de.intarsys.security.signme.activity.SignMeActivity;
import de.intarsys.security.signme.activity.SignMeCommonRegistrationActivity;
import de.intarsys.security.signme.activity.SignMePortalRegistrationActivity;
import de.intarsys.security.signme.activity.SignMePortalSignActivity;
import de.intarsys.security.signme.activity.SignMePortalVerificationActivity;
import de.intarsys.security.signme.common.IdentityVerificationType;
import de.intarsys.security.signme.common.SignMeSignatureFormat;
import de.intarsys.security.signme.common.SignMeTools;
import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.IInteraction;
import de.intarsys.tools.activity.StagedInteraction;
import de.intarsys.tools.concurrent.ForwardFailure;
import de.intarsys.tools.concurrent.ForwardTermination;
import de.intarsys.tools.concurrent.IPromise;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.message.IMessageBundle;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignMePortalGuardedSignActivity<P extends IActivity<?>>
extends SignMeActivity<List<byte[]>, P> {
    private static final Logger Log = LoggerFactory.getLogger(SignMePortalGuardedSignActivity.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private SignMePortalRegistrationActivity<?> registrationActivity;
    private SignMePortalVerificationActivity<?> verificationActivity;
    private Boolean registrationConfirmed;
    private SignMePortalSignActivity<?> signActivity;
    private IdentityVerificationType identityVerificationType;
    private boolean checkConfirmationEmail = false;
    private SignMeSignatureFormat signatureFormat;
    private String queryStringVerification;
    private String queryStringRegistration;
    private ECDSAChallengeSigner challengeSigner;

    public SignMePortalGuardedSignActivity() {
    }

    public SignMePortalGuardedSignActivity(P parent) {
        super(parent);
    }

    public void checkSignatureProcessState() {
        this.ensureValid();
        this.getSignActivity().checkSignatureProcessState();
    }

    protected SignMePortalRegistrationActivity createRegistrationActivity() {
        SignMePortalRegistrationActivity activity = new SignMePortalRegistrationActivity();
        try {
            activity.addTaskCallback((ITaskCallback)new ForwardFailure((IPromise)this));
            activity.setSession(this.getSession());
            activity.setQueryString(this.getQueryStringRegistration());
            activity.setRedirectUriProvider(this.getRedirectUriProvider());
            activity.setRedirectParamValue(this.getRedirectParamValue());
            activity.setRedirectParamName(this.getRedirectParamName());
            activity.setUsername(this.getUsername());
            activity.setIdentity(this.getIdentity());
            activity.enter();
            Log.debug("{} createRegistrationActivity finished", (Object)this.getLogLabel());
        }
        catch (Exception e) {
            CommonSecurityException tmpEx = SignMeTools.handleError(e);
            String error = ExceptionTools.getMessage((Throwable)tmpEx);
            this.setMessage(Msg.getString("SignMeRegistrationActivity.error.registrationFailed", new Object[]{error}));
            Log.debug("{} createRegistrationActivity failed ({})", (Object)this.getLogLabel(), (Object)error);
            activity.fail(tmpEx);
        }
        return activity;
    }

    protected Boolean createRegistrationConfirmed() {
        try {
            Person identity = this.getIdentity();
            if (identity == null) {
                return false;
            }
            IdentityVerificationState state = identity.getIdentityVerificationState();
            Log.debug("{} createRegistrationConfirmed result {}", (Object)this.getLogLabel(), (Object)state);
            return state != null && !state.equals((Object)IdentityVerificationState.UNVERIFIED);
        }
        catch (CommonSecurityException e) {
            CommonSecurityException tmpEx = SignMeTools.handleError(e);
            String error = ExceptionTools.getMessage((Throwable)tmpEx);
            Log.debug("{} createRegistrationConfirmed failed ({})", (Object)this.getLogLabel(), (Object)error);
            return false;
        }
    }

    protected SignMePortalSignActivity<?> createSignActivity() {
        SignMePortalSignActivity activity = new SignMePortalSignActivity();
        activity.addTaskCallback((ITaskCallback)new ForwardTermination((IPromise)this));
        activity.setSession(this.getSession());
        activity.setQueryString(this.getQueryString());
        activity.setRedirectUriProvider(this.getRedirectUriProvider());
        activity.setRedirectParamValue(this.getRedirectParamValue());
        activity.setRedirectParamName(this.getRedirectParamName());
        activity.setUsername(this.getUsername());
        activity.setSignatureFormat(this.getSignatureFormat());
        activity.setChallengeSigner(this.getChallengeSigner());
        activity.setSignatureLevel(this.getSignatureLevel());
        return activity;
    }

    protected SignMePortalVerificationActivity createVerificationActivity() {
        SignMePortalVerificationActivity activity = new SignMePortalVerificationActivity();
        try {
            activity.setCheckConfirmationEmail(this.isCheckConfirmationEmail());
            activity.addTaskCallback((ITaskCallback)new ForwardFailure((IPromise)this));
            activity.setSession(this.getSession());
            if (this.getIdentityVerificationType() != null) {
                activity.setIdentityVerificationType(this.getIdentityVerificationType());
            }
            activity.setQueryString(this.getQueryStringVerification());
            activity.setRedirectUriProvider(this.getRedirectUriProvider());
            activity.setRedirectParamValue(this.getRedirectParamValue());
            activity.setRedirectParamName(this.getRedirectParamName());
            activity.setUsername(this.getUsername());
            activity.setSignatureLevel(this.getSignatureLevel());
            activity.setSignerStatus(this.getSignerStatus());
            activity.enter();
            Log.debug("{} createVerificationActivity finished", (Object)this.getLogLabel());
        }
        catch (Exception e) {
            CommonSecurityException tmpEx = SignMeTools.handleError(e);
            String error = ExceptionTools.getMessage((Throwable)tmpEx);
            this.setMessage(Msg.getString("SignMeVerificationActivity.error.verificationFailed", new Object[]{error}));
            Log.debug("{} createVerificationActivity failed ({})", (Object)this.getLogLabel(), (Object)error);
            activity.fail(tmpEx);
        }
        return activity;
    }

    public IInteraction<Void, Void> enterConsentInteraction() {
        this.ensureValid();
        return this.getSignActivity().enterConsentInteraction();
    }

    public IInteraction<Void, Void> enterRegistrationInteraction() {
        this.ensureValid();
        IInteraction<Void, Void> interaction = this.getRegistrationActivity().enterRegistrationInteraction();
        CompletionStage<Void> nextStage = interaction.getStage().whenComplete((result, ex) -> this.synchronizeState());
        return StagedInteraction.wrap(interaction, nextStage);
    }

    public IInteraction<Void, Void> enterVerificationInteraction() {
        this.ensureValid();
        IInteraction<Void, Void> interaction = this.getVerificationActivity().enterIdentityVerificationInteraction();
        interaction.getStage().whenComplete((result, ex) -> this.synchronizeState());
        return interaction;
    }

    public IX509PublicKeyCertificate[] getCertificatePath() {
        return this.signActivity == null ? null : this.signActivity.getCertificatePath();
    }

    public ECDSAChallengeSigner getChallengeSigner() {
        return this.challengeSigner;
    }

    public String getConsentInteractionUrl() {
        return this.getSignActivity().getConsentInteractionUrl();
    }

    public String getIdentityVerificationInteractionUrl() {
        return this.getVerificationActivity().getIdentityVerificationInteractionUrl();
    }

    public String getIdentityVerificationProcessId() {
        if (this.verificationActivity == null) {
            return null;
        }
        return this.verificationActivity.getIdentityVerificationProcessId();
    }

    public IdentityVerificationType getIdentityVerificationType() {
        return this.identityVerificationType;
    }

    public String getQueryStringRegistration() {
        return this.queryStringRegistration;
    }

    public String getQueryStringVerification() {
        return this.queryStringVerification;
    }

    public SignMePortalRegistrationActivity<?> getRegistrationActivity() {
        if (this.registrationActivity == null) {
            this.registrationActivity = this.createRegistrationActivity();
        }
        return this.registrationActivity;
    }

    public String getRegistrationInteractionUrl() {
        return this.getRegistrationActivity().getRegistrationInteractionUrl();
    }

    public SignMeCommonRegistrationActivity.RegistrationProperties getRegistrationProperties() {
        return this.getRegistrationActivity().getProperties();
    }

    protected SignMePortalSignActivity<?> getSignActivity() {
        if (this.signActivity == null) {
            this.signActivity = this.createSignActivity();
        }
        return this.signActivity;
    }

    public SignMeSignatureFormat getSignatureFormat() {
        return this.signatureFormat;
    }

    public SignatureProcess getSignatureProcess() {
        if (this.signActivity == null) {
            return null;
        }
        return this.getSignActivity().getSignatureProcess();
    }

    public SignMePortalVerificationActivity<?> getVerificationActivity() {
        if (this.verificationActivity == null) {
            this.verificationActivity = this.createVerificationActivity();
        }
        return this.verificationActivity;
    }

    public String getVerificationInteractionUrl() {
        return this.getVerificationActivity().getIdentityVerificationInteractionUrl();
    }

    public boolean isCheckConfirmationEmail() {
        return this.checkConfirmationEmail;
    }

    public boolean isRegistered() {
        return this.getRegistrationActivity().isDone();
    }

    public boolean isRegistrationConfirmed() {
        if (this.registrationConfirmed == null) {
            this.registrationConfirmed = this.createRegistrationConfirmed();
        }
        return this.registrationConfirmed;
    }

    public boolean isVerified() {
        return this.getVerificationActivity().isDone();
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        Log.debug("{} resetCache", (Object)this.getLogLabel());
        this.registrationConfirmed = null;
        if (this.registrationActivity != null) {
            this.registrationActivity.resetCache();
        }
        if (this.verificationActivity != null) {
            this.verificationActivity.resetCache();
        }
        if (this.signActivity != null) {
            this.signActivity.resetCache();
        }
    }

    @Override
    protected void resetState() {
        super.resetState();
        Log.debug("{} resetState", (Object)this.getLogLabel());
        this.registrationActivity = null;
        this.signActivity = null;
        this.verificationActivity = null;
        this.resetCache();
    }

    public void setChallengeSigner(ECDSAChallengeSigner challengeSigner) {
        this.challengeSigner = challengeSigner;
        if (this.signActivity != null) {
            this.signActivity.setChallengeSigner(challengeSigner);
        }
    }

    public void setCheckConfirmationEmail(boolean value) {
        this.checkConfirmationEmail = value;
    }

    public void setIdentityVerificationType(IdentityVerificationType identityVerificationType) {
        this.identityVerificationType = identityVerificationType;
    }

    public void setQueryStringRegistration(String queryStringRegistration) {
        this.queryStringRegistration = queryStringRegistration;
    }

    public void setQueryStringVerification(String queryStringVerification) {
        this.queryStringVerification = queryStringVerification;
    }

    @Override
    public void setRedirectParamName(String value) {
        super.setRedirectParamName(value);
        if (this.signActivity != null) {
            this.signActivity.setRedirectParamName(value);
        }
        if (this.registrationActivity != null) {
            this.registrationActivity.setRedirectParamName(value);
        }
        if (this.verificationActivity != null) {
            this.verificationActivity.setRedirectParamName(value);
        }
    }

    @Override
    public void setRedirectParamValue(String value) {
        super.setRedirectParamValue(value);
        if (this.signActivity != null) {
            this.signActivity.setRedirectParamValue(value);
        }
        if (this.registrationActivity != null) {
            this.registrationActivity.setRedirectParamValue(value);
        }
        if (this.verificationActivity != null) {
            this.verificationActivity.setRedirectParamValue(value);
        }
    }

    public void setSignatureFormat(SignMeSignatureFormat signatureFormat) {
        this.signatureFormat = signatureFormat;
        if (this.signActivity != null) {
            this.signActivity.setSignatureFormat(this.getSignatureFormat());
        }
    }

    public SignatureProcess signPrepare() throws CommonSecurityException {
        return this.getSignActivity().signPrepare();
    }

    public void signUpdate(List<SignatureTask> tasks) throws CommonSecurityException {
        this.getSignActivity().signUpdate(tasks);
    }
}

