/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signme.activity;

import de.bdr.signme.api.v2.gen.Person;
import de.bdr.signme.api.v2.gen.RedirectURLs;
import de.bdr.signme.api.v2.gen.RegistrationProcess;
import de.intarsys.security.common.CommonSecurityException;
import de.intarsys.security.signme.activity.PACKAGE;
import de.intarsys.security.signme.activity.SignMeCommonRegistrationActivity;
import de.intarsys.security.signme.common.SignMeTools;
import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.IInteraction;
import de.intarsys.tools.activity.SimpleInteraction;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignMePortalRegistrationActivity<P extends IActivity<?>>
extends SignMeCommonRegistrationActivity<P> {
    private static final Logger Log = LoggerFactory.getLogger(SignMePortalRegistrationActivity.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private RegistrationProcess registrationProcess;

    public SignMePortalRegistrationActivity() {
    }

    public SignMePortalRegistrationActivity(P parent) {
        super(parent);
    }

    public IInteraction<Void, Void> enterRegistrationInteraction() {
        try {
            this.ensureValid();
            if (this.isDone()) {
                try {
                    return SimpleInteraction.completed(null, (Object)((Void)this.get()));
                }
                catch (Exception e2) {
                    return SimpleInteraction.failed(null, (Throwable)e2);
                }
            }
            this.registrationProcess = this.signMeCreateRegistrationProcess();
            CompletableFuture completable = new CompletableFuture();
            CompletionStage stage = ((CompletableFuture)((CompletableFuture)completable.whenComplete((result, ex) -> this.synchronizeState())).thenAccept(ignore -> {
                Log.debug("{} registration interaction finished", (Object)this.getLogLabel());
                this.ok();
            })).exceptionally(e -> {
                CommonSecurityException tmpEx = SignMeTools.handleError(e);
                String error = ExceptionTools.getMessage((Throwable)tmpEx);
                Log.debug("{} registration interaction failed {}", (Object)this.getLogLabel(), (Object)error);
                this.setMessage(Msg.getString("SignMeRegistrationActivity.error.registrationFailed", new Object[]{error}));
                throw SignMeTools.rethrowable(e);
            });
            return new SimpleInteraction((Object)null, completable, stage);
        }
        catch (Exception e3) {
            CommonSecurityException tmpEx = SignMeTools.handleError(e3);
            this.setMessage(ExceptionTools.getMessage((Throwable)tmpEx));
            return SimpleInteraction.failed(null, (Throwable)tmpEx);
        }
    }

    public String getRegistrationInteractionUrl() {
        if (this.getRegistrationProcess() == null) {
            return null;
        }
        return this.createInteractionUrl(this.getRegistrationProcess().getRegistrationProcessURL());
    }

    public RegistrationProcess getRegistrationProcess() {
        return this.registrationProcess;
    }

    public void setRegistrationProcess(RegistrationProcess registrationProcess) {
        this.registrationProcess = registrationProcess;
    }

    protected RegistrationProcess signMeCreateRegistrationProcess() throws CommonSecurityException {
        try {
            RedirectURLs redirectURLs = this.createRedirectUrls();
            Person person = new Person();
            person.setFamilyNames("");
            person.setGivenNames("");
            person.setEmailAddress(StringTools.isEmpty((String)this.getProperties().getEmail()) ? this.getUsername() : this.getProperties().getEmail());
            RegistrationProcess process = this.getSession().createRegistrationProcess(redirectURLs, person);
            return process;
        }
        catch (Exception e) {
            throw SignMeTools.handleError(e);
        }
    }

    @Override
    protected boolean validate() {
        return super.validate();
    }
}

