/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signme.activity;

import de.bdr.signme.api.v2.ECDSAChallengeSigner;
import de.bdr.signme.api.v2.gen.AccessTokenGrant;
import de.bdr.signme.api.v2.gen.AuthenticationTokenSelector;
import de.bdr.signme.api.v2.gen.Certificate;
import de.bdr.signme.api.v2.gen.ItemProcessingResult;
import de.bdr.signme.api.v2.gen.ItemToBeProcessed;
import de.bdr.signme.api.v2.gen.RedirectURLs;
import de.bdr.signme.api.v2.gen.SignMeException;
import de.bdr.signme.api.v2.gen.SignatureProcess;
import de.bdr.signme.api.v2.gen.SignatureState;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.common.AuthenticationCanceled;
import de.intarsys.security.common.CommonSecurityException;
import de.intarsys.security.signature.common.SignatureTask;
import de.intarsys.security.signme.activity.SignMeActivity;
import de.intarsys.security.signme.activity.SignMeTimeout;
import de.intarsys.security.signme.common.SignMeSignatureFormat;
import de.intarsys.security.signme.common.SignMeTools;
import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.IInteraction;
import de.intarsys.tools.activity.SimpleInteraction;
import de.intarsys.tools.exception.ExceptionTools;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignMePortalSignActivity<P extends IActivity<?>>
extends SignMeActivity<List<byte[]>, P> {
    private static final Logger Log = LoggerFactory.getLogger(SignMePortalSignActivity.class);
    private static final String AUTH_TOKEN_ADMINISTER = "SIDTK";
    private static final String ROLE_PARTNER = "PARTNER";
    private SignatureProcess signatureProcess;
    private SignMeSignatureFormat signatureFormat = SignMeSignatureFormat.CMS_BASIC;
    private ECDSAChallengeSigner challengeSigner;
    private IX509PublicKeyCertificate[] certificatePath;

    public SignMePortalSignActivity() {
    }

    public SignMePortalSignActivity(P parent) {
        super(parent);
    }

    protected void authorizeProcess() throws SignMeException {
        Log.debug("{} entered sealing authorize process", (Object)this.getLogLabel());
        if (this.getChallengeSigner() == null) {
            throw new SignMeException("no authorization token available");
        }
        Log.trace("{} authorize sealing process for access token grant started", (Object)this.getLogLabel());
        AuthenticationTokenSelector authenticationTokenSelector = new AuthenticationTokenSelector();
        authenticationTokenSelector.setAuthenticationTokenType(AUTH_TOKEN_ADMINISTER);
        authenticationTokenSelector.setUsername(this.getUsername());
        AccessTokenGrant accessTokenGrant = this.getSession().authorizeProcess(ROLE_PARTNER, authenticationTokenSelector, this.getSignatureProcess().getSignatureProcessId());
        if (!accessTokenGrant.isNeedsStep2()) {
            throw new SignMeException("sealing authorization challenge signing expected");
        }
        Log.trace("{} authorize sealing process for access token grant finished", (Object)this.getLogLabel());
        byte[] challenge = (byte[])accessTokenGrant.getAuthenticationData().get(0);
        Log.trace("{} authorize sealing process challenge signing started", (Object)this.getLogLabel());
        byte[] signedChallenge = this.getChallengeSigner().sign(challenge);
        ArrayList<byte[]> authenticationDataStep2 = new ArrayList<byte[]>();
        authenticationDataStep2.add(signedChallenge);
        this.getSession().authorizeProcessStep2(authenticationDataStep2);
        Log.trace("{} authorize sealing process challenge signing finished", (Object)this.getLogLabel());
    }

    public void checkSignatureProcessState() {
        if (this.isDone()) {
            return;
        }
        try {
            if (this.signMeGetSignatureProcessIsFinished()) {
                List<byte[]> result = this.signMeGetSignatureProcessResult();
                this.finish(result);
            }
        }
        catch (Exception e) {
            this.fail(SignMeTools.handleError(e));
        }
    }

    protected void createItemToBeProcessed(List<ItemToBeProcessed> itemsToBeProcessed, SignatureTask task) throws CommonSecurityException {
        ItemToBeProcessed itemToBeProcessed = new ItemToBeProcessed();
        itemToBeProcessed.setName(SignMeTools.trimItemName(task.name));
        itemToBeProcessed.setContent(task.toBeSignedData.getEncodedDigest());
        itemsToBeProcessed.add(itemToBeProcessed);
    }

    public IInteraction<Void, Void> enterConsentInteraction() {
        if (this.isSealing()) {
            try {
                this.authorizeProcess();
                Log.debug("{} sealing authorization process finished", (Object)this.getLogLabel());
                return SimpleInteraction.completed(null, null);
            }
            catch (SignMeException e2) {
                return SimpleInteraction.failed(null, (Throwable)e2);
            }
        }
        CompletableFuture completable = new CompletableFuture();
        CompletionStage stage = ((CompletableFuture)completable.thenAccept(ignore -> {
            Log.debug("{} consent interaction finished", (Object)this.getLogLabel());
            this.checkSignatureProcessState();
        })).exceptionally(e -> {
            CommonSecurityException tmpEx = SignMeTools.handleError(e);
            String error = ExceptionTools.getMessage((Throwable)tmpEx);
            Log.debug("{} consent interaction failed {}", (Object)this.getLogLabel(), (Object)error);
            this.signMeCancelSignatureProcess();
            this.fail(tmpEx);
            throw SignMeTools.rethrowable(tmpEx);
        });
        return new SimpleInteraction((Object)null, completable, stage);
    }

    public IX509PublicKeyCertificate[] getCertificatePath() {
        return this.certificatePath;
    }

    public ECDSAChallengeSigner getChallengeSigner() {
        return this.challengeSigner;
    }

    public String getConsentInteractionUrl() {
        return this.createInteractionUrl(this.getSignatureProcess().getSignatureProcessURL());
    }

    public String getLogLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getLogLabel());
        sb.append(", process ");
        if (this.getSignatureProcess() == null) {
            sb.append("undefined");
        } else {
            sb.append(this.getSignatureProcess().getSignatureProcessId());
        }
        return sb.toString();
    }

    public SignMeSignatureFormat getSignatureFormat() {
        return this.signatureFormat == null ? SignMeSignatureFormat.CMS_BASIC : this.signatureFormat;
    }

    public SignatureProcess getSignatureProcess() {
        return this.signatureProcess;
    }

    protected boolean isSealing() {
        return this.getSignatureLevel().isSealing();
    }

    protected void onCancelled() {
        super.onCancelled();
        this.signMeCancelSignatureProcess();
    }

    public void setCertificatePath(IX509PublicKeyCertificate[] certificatePath) {
        this.certificatePath = certificatePath;
    }

    public void setChallengeSigner(ECDSAChallengeSigner challengeSigner) {
        this.challengeSigner = challengeSigner;
    }

    public void setSignatureFormat(SignMeSignatureFormat signatureFormat) {
        this.signatureFormat = signatureFormat;
    }

    public void setSignatureProcess(SignatureProcess signatureProcess) {
        this.signatureProcess = signatureProcess;
    }

    protected void signMeCancelSignatureProcess() {
        try {
            if (this.getSignatureProcess() == null) {
                return;
            }
            this.getSession().cancelSignatureProcess(this.getSignatureProcess().getSignatureProcessId());
        }
        catch (Exception e) {
            CommonSecurityException tmpEx = SignMeTools.handleError(e);
            Log.warn("{} signMeCancelSignatureProcess failed ({})", (Object)this.getLogLabel(), (Object)ExceptionTools.getMessage((Throwable)tmpEx));
        }
    }

    protected SignatureProcess signMeCreateSignatureProcess() throws CommonSecurityException {
        RedirectURLs redirectURLs = this.createRedirectUrls();
        String signatureType = SignMeTools.getSignatureTypeDigest(this.getSignatureLevel(), this.getSignatureFormat());
        String signerUsername = this.getUsername();
        try {
            SignatureProcess signatureProcess = this.getSession().createSignatureProcess(signatureType, null, signerUsername, null, new ArrayList(), redirectURLs, Boolean.valueOf(true));
            return signatureProcess;
        }
        catch (Exception e) {
            throw SignMeTools.handleError(e);
        }
    }

    protected List<Certificate> signMeGetCertificates(String id) throws CommonSecurityException {
        try {
            List path = this.getSession().getCertificate(id, true);
            return path;
        }
        catch (Exception e) {
            throw SignMeTools.handleError(e);
        }
    }

    protected boolean signMeGetSignatureProcessIsFinished() throws CommonSecurityException {
        String processId = this.getSignatureProcess().getSignatureProcessId();
        try {
            SignatureProcess process = this.getSession().getSignatureProcess(processId, false, false, false);
            List items = process.getItemsAndTheirProcessingResults();
            for (ItemProcessingResult item : items) {
                SignatureState signatureState = item.getSignatureState();
                switch (signatureState) {
                    case REQUESTED: {
                        return false;
                    }
                    case NOK_ERROR: 
                    case NOK_TIMEOUT: {
                        throw new SignMeTimeout("Signature " + processId + " failed");
                    }
                    case CANCELLED: {
                        throw new AuthenticationCanceled();
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            throw SignMeTools.handleError(e);
        }
    }

    protected List<byte[]> signMeGetSignatureProcessResult() throws CommonSecurityException {
        String processId = this.getSignatureProcess().getSignatureProcessId();
        try {
            SignatureProcess process = this.getSession().getSignatureProcess(processId, true, false, false);
            List itemProcessingResults = process.getItemsAndTheirProcessingResults();
            ArrayList<byte[]> signatures = new ArrayList<byte[]>();
            for (ItemProcessingResult item : itemProcessingResults) {
                signatures.add(item.getContentOrSignedContent());
            }
            return signatures;
        }
        catch (Exception e) {
            throw SignMeTools.handleError(e);
        }
    }

    protected void signMeUpdateSignatureProcess(List<SignatureTask> tasks) throws CommonSecurityException {
        try {
            LinkedList<ItemToBeProcessed> itemsToBeProcessed = new LinkedList<ItemToBeProcessed>();
            for (SignatureTask task : tasks) {
                this.createItemToBeProcessed(itemsToBeProcessed, task);
            }
            this.getSession().updateSignatureProcess(this.getSignatureProcess().getSignatureProcessId(), itemsToBeProcessed);
        }
        catch (Exception e) {
            throw SignMeTools.handleError(e);
        }
    }

    public SignatureProcess signPrepare() throws CommonSecurityException {
        Log.trace("{} signPrepare", (Object)this.getLogLabel());
        try {
            this.setSignatureProcess(this.signMeCreateSignatureProcess());
            Certificate certificate = this.getSignatureProcess().getCertificateV2();
            List<Certificate> path = this.signMeGetCertificates(certificate.getIssuerCertificateId());
            IX509PublicKeyCertificate[] tempPath = (IX509PublicKeyCertificate[])Stream.concat(Stream.of(certificate), path.stream()).map(cert -> cert.getCertificate()).map(bytes -> {
                try {
                    return X509CertificateFactory.get().createCertificate(bytes);
                }
                catch (CertificateException e) {
                    throw new CompletionException(e);
                }
            }).toArray(IX509PublicKeyCertificate[]::new);
            Log.debug("{} signPrepare finished", (Object)this.getLogLabel());
            this.setCertificatePath(tempPath);
            return this.getSignatureProcess();
        }
        catch (Exception e) {
            throw SignMeTools.handleError(e);
        }
    }

    public void signUpdate(List<SignatureTask> tasks) throws CommonSecurityException {
        Log.trace("{} signUpdate", (Object)this.getLogLabel());
        try {
            this.signMeUpdateSignatureProcess(tasks);
            Log.debug("{} signUpdate finished", (Object)this.getLogLabel());
        }
        catch (Exception e) {
            throw SignMeTools.handleError(e);
        }
    }
}

