/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signme.activity;

import de.bdr.signme.api.v2.gen.IdentityVerificationProcess;
import de.bdr.signme.api.v2.gen.RedirectURLs;
import de.bdr.signme.api.v2.gen.SignerStatus;
import de.intarsys.security.common.CommonSecurityException;
import de.intarsys.security.signme.activity.PACKAGE;
import de.intarsys.security.signme.activity.SignMeActivity;
import de.intarsys.security.signme.activity.SignerNotExisting;
import de.intarsys.security.signme.activity.SignerStatusInsufficient;
import de.intarsys.security.signme.common.IdentityVerificationType;
import de.intarsys.security.signme.common.Messages;
import de.intarsys.security.signme.common.SignMeSignatureLevel;
import de.intarsys.security.signme.common.SignMeTools;
import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.IInteraction;
import de.intarsys.tools.activity.SimpleInteraction;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignMePortalVerificationActivity<P extends IActivity<?>>
extends SignMeActivity<Void, P> {
    private static final Logger Log = LoggerFactory.getLogger(SignMePortalVerificationActivity.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private boolean inlinePossible = false;
    private boolean reuseVerificationProcess = true;
    private boolean checkConfirmationEmail = false;
    private String identityVerificationInteractionUrl;
    private IdentityVerificationType identityVerificationType = IdentityVerificationType.FT_E_ID;
    private CommonSecurityException validationException;
    private String identityVerificationProcessId;

    public SignMePortalVerificationActivity() {
    }

    public SignMePortalVerificationActivity(P parent) {
        super(parent);
    }

    protected void checkVerify(SignerStatus status) {
        String tmpMessage;
        CommonSecurityException tmpException = null;
        try {
            if (status == null) {
                this.inlinePossible = false;
                tmpMessage = Messages.getString("Error.signerNotExisting.label", new Object[0]);
                tmpException = new SignerNotExisting(tmpMessage);
            } else if (status.isSigningPossible() && !this.isForceFail("")) {
                this.inlinePossible = false;
                tmpMessage = Msg.getString("SignMeVerificationActivity.verificationFinished", new Object[0]);
            } else if (!status.isSignerExisting() || this.isForceFail("signerNotExisting")) {
                this.inlinePossible = false;
                tmpMessage = Messages.getString("Error.signerNotExisting.label", new Object[0]);
                tmpException = new SignerNotExisting(tmpMessage);
            } else if (status.getActiveIdentityVerficationProcessURL() != null) {
                this.inlinePossible = true;
                tmpMessage = Msg.getString("SignMeVerificationActivity.activeIdentityVerficationProcessURL.label", new Object[0]);
            } else if ((this.isCheckConfirmationEmail() || this.getSignatureLevel() == SignMeSignatureLevel.BASIC) && status.isSignerEmailAddressNeedsConfirmation() || this.isForceFail("signerEmailAddressNeedsConfirmation")) {
                this.inlinePossible = false;
                tmpMessage = Messages.getString("Error.signerEmailAddressNeedsConfirmation.label", new Object[0]);
                tmpException = new SignerStatusInsufficient(tmpMessage);
            } else if (status.isSignerPasswordNeedsReset() || this.isForceFail("signerPasswordNeedsReset")) {
                tmpMessage = Messages.getString("Error.signerPasswordNeedsReset.label", new Object[0]);
                tmpException = new SignerStatusInsufficient(tmpMessage);
            } else if (status.isSignerPasswordNeedsChangeOfInitPassword() || this.isForceFail("signerPasswordNeedsChangeOfInitPassword")) {
                tmpMessage = Messages.getString("Error.signerPasswordNeedsChangeOfInitPassword.label", new Object[0]);
                tmpException = new SignerStatusInsufficient(tmpMessage);
            } else if (!status.isCoinBalanceSufficient() || this.isForceFail("coinBalanceInsufficient")) {
                tmpMessage = Messages.getString("Error.coinBalanceInsufficient.label", new Object[0]);
                tmpException = new SignerStatusInsufficient(tmpMessage);
            } else if (status.isSignerNeedsToAgreeToTermsAndConditions() || this.isForceFail("signerNeedsToAgreeToTermsAndConditions")) {
                tmpMessage = Messages.getString("Error.signerNeedsToAgreeToTermsAndConditions.label", new Object[0]);
                tmpException = new SignerStatusInsufficient(tmpMessage);
            } else if (status.isSignerNeedsIdentificationAndTokenCreation()) {
                this.inlinePossible = true;
                tmpMessage = Msg.getString("SignMeVerificationActivity.signerNeedsIdentificationAndTokenCreation.label", new Object[0]);
            } else {
                this.inlinePossible = false;
                tmpMessage = Messages.getString("Error.signingNotPossibleOther.label", new Object[0]);
                tmpException = new SignerStatusInsufficient(tmpMessage);
            }
        }
        catch (Exception e) {
            this.inlinePossible = false;
            tmpException = SignMeTools.handleError(e);
            tmpMessage = ExceptionTools.getMessage((Throwable)tmpException);
        }
        this.setMessage(tmpMessage);
        this.setValidationException(tmpException);
        Log.debug("{} checkVerify ({})", (Object)this.getLogLabel(), (Object)this.getMessage());
    }

    public IInteraction<Void, Void> enterIdentityVerificationInteraction() {
        try {
            this.ensureValid();
            if (this.isDone()) {
                try {
                    return SimpleInteraction.completed(null, (Object)((Void)this.get()));
                }
                catch (Exception e2) {
                    return SimpleInteraction.failed(null, (Throwable)e2);
                }
            }
            SignerStatus tmpStatus = this.getSignerStatus();
            this.checkVerify(tmpStatus);
            if (this.getValidationException() != null) {
                this.synchronizeState();
                return SimpleInteraction.failed(null, (Throwable)this.getValidationException());
            }
            if (tmpStatus.isSigningPossible()) {
                this.synchronizeState();
                this.ok();
                return SimpleInteraction.completed((Object)((Void)this.get()), null);
            }
            if (!this.isInlinePossible()) {
                this.synchronizeState();
                return SimpleInteraction.failed(null, (Throwable)((Object)new SignerStatusInsufficient(this.getMessage())));
            }
            this.identityVerificationInteractionUrl = tmpStatus.getActiveIdentityVerficationProcessURL();
            if (!this.isReuseVerificationProcess() || StringTools.isEmpty((String)this.identityVerificationInteractionUrl)) {
                IdentityVerificationProcess verificationProcess = this.signMeCreateIdentityVerificationProcess();
                this.identityVerificationProcessId = verificationProcess.getIdentityVerificationProcessId();
                this.identityVerificationInteractionUrl = verificationProcess.getIdentityVerificationProcessURL();
            } else {
                this.identityVerificationProcessId = tmpStatus.getActiveIdentityVerficationProcessId();
            }
            CompletableFuture completable = new CompletableFuture();
            CompletionStage stage = ((CompletableFuture)((CompletableFuture)completable.whenComplete((result, ex) -> this.synchronizeState())).thenAccept(ignore -> {
                Log.debug("{} verification interaction finished", (Object)this.getLogLabel());
                this.ok();
            })).exceptionally(e -> {
                CommonSecurityException tmpEx = SignMeTools.handleError(e);
                String error = ExceptionTools.getMessage((Throwable)tmpEx);
                Log.debug("{} verification interaction failed {}", (Object)this.getLogLabel(), (Object)error);
                this.setMessage(Msg.getString("SignMeVerificationActivity.error.verificationFailed", new Object[]{error}));
                throw SignMeTools.rethrowable(e);
            });
            return new SimpleInteraction((Object)null, completable, stage);
        }
        catch (Exception e3) {
            CommonSecurityException tmpEx = SignMeTools.handleError(e3);
            this.setMessage(ExceptionTools.getMessage((Throwable)tmpEx));
            return SimpleInteraction.failed(null, (Throwable)tmpEx);
        }
    }

    protected void execute() throws Exception {
        super.execute();
        try {
            SignerStatus tmpStatus = this.getSignerStatus();
            this.checkVerify(tmpStatus);
            if (this.getValidationException() == null && tmpStatus != null && tmpStatus.isSigningPossible()) {
                this.ok();
            }
        }
        catch (Exception e) {
            CommonSecurityException tmpEx = SignMeTools.handleError(e);
            this.setMessage(Msg.getString("SignMeVerificationActivity.error.verificationFailed", new Object[]{ExceptionTools.getMessage((Throwable)tmpEx)}));
        }
    }

    public String getIdentityVerificationInteractionUrl() {
        return this.createInteractionUrl(this.identityVerificationInteractionUrl);
    }

    public String getIdentityVerificationProcessId() {
        return this.identityVerificationProcessId;
    }

    public IdentityVerificationType getIdentityVerificationType() {
        return this.identityVerificationType;
    }

    public CommonSecurityException getValidationException() {
        return this.validationException;
    }

    public boolean isCheckConfirmationEmail() {
        return this.checkConfirmationEmail;
    }

    private boolean isForceFail(String tag) {
        return this.getUsername().contains("+fail." + tag);
    }

    public boolean isInlinePossible() {
        return this.inlinePossible;
    }

    public boolean isReuseVerificationProcess() {
        return this.reuseVerificationProcess;
    }

    public void setCheckConfirmationEmail(boolean checkConfirmationEmail) {
        this.checkConfirmationEmail = checkConfirmationEmail;
    }

    public void setIdentityVerificationProcessId(String verificationProcessId) {
        this.identityVerificationProcessId = verificationProcessId;
    }

    public void setIdentityVerificationType(IdentityVerificationType identityVerificationType) {
        this.identityVerificationType = identityVerificationType;
    }

    public void setReuseVerificationProcess(boolean reuseVerificationProcess) {
        this.reuseVerificationProcess = reuseVerificationProcess;
    }

    public void setValidationException(CommonSecurityException validationException) {
        this.validationException = validationException;
    }

    protected IdentityVerificationProcess signMeCreateIdentityVerificationProcess() throws CommonSecurityException {
        try {
            RedirectURLs redirectURLs = this.createRedirectUrls();
            IdentityVerificationProcess process = this.getSession().createIdentityVerificationProcess(this.getIdentityVerificationType().getName(), this.getUsername(), redirectURLs);
            return process;
        }
        catch (Exception e) {
            throw SignMeTools.handleError(e);
        }
    }
}

