/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signme.common;

import de.bdr.signme.api.v2.ApiSession;
import de.bdr.signme.api.v2.Credentials;
import de.bdr.signme.api.v2.SignMeApiV2Ext;
import de.bdr.signme.api.v2.gen.TokenCapability;
import de.intarsys.security.common.CommonSecurityException;
import de.intarsys.security.signme.activity.SignMeGatewayError;
import de.intarsys.security.signme.common.IdentityVerificationType;
import de.intarsys.tools.crypto.Secret;
import java.security.GeneralSecurityException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartnerAccess {
    private static final Logger log = LoggerFactory.getLogger(PartnerAccess.class);
    private SignMeApiV2Ext signMeApi;
    private String partnerUser;
    private Secret partnerPassword;
    private String partnerRole;
    private List<TokenCapability> tokenCapabilites;
    private IdentityVerificationType identityVerificationType;
    private ApiSession apiSession;

    public static String createKey(String username, String role) {
        return username + "-" + role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiSession getApiSession() {
        PartnerAccess partnerAccess = this;
        synchronized (partnerAccess) {
            return this.apiSession;
        }
    }

    public String getId() {
        return PartnerAccess.createKey(this.partnerUser, this.partnerRole);
    }

    public IdentityVerificationType getIdentityVerificationType() {
        return this.identityVerificationType;
    }

    public Secret getPartnerPassword() {
        return this.partnerPassword;
    }

    public String getPartnerRole() {
        return this.partnerRole;
    }

    public String getPartnerUser() {
        return this.partnerUser;
    }

    public SignMeApiV2Ext getSignMeApi() {
        return this.signMeApi;
    }

    public List<TokenCapability> getTokenCapabilites() {
        return this.tokenCapabilites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login() throws CommonSecurityException {
        PartnerAccess partnerAccess = this;
        synchronized (partnerAccess) {
            if (this.apiSession != null) {
                log.info("{} login, existing session", (Object)this);
                this.apiSession.getSecurityHeader();
                return;
            }
            log.info("{} login, new session", (Object)this);
            try {
                Credentials creds = this.getSignMeApi().createCredentialsUidPw(this.getPartnerRole(), this.getPartnerUser(), this.getPartnerPassword().getString());
                this.apiSession = this.getSignMeApi().openAppProviderSession(creds);
            }
            catch (GeneralSecurityException e) {
                throw new SignMeGatewayError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        PartnerAccess partnerAccess = this;
        synchronized (partnerAccess) {
            if (this.apiSession == null) {
                log.info("{} logout, no session", (Object)this);
                return;
            }
            log.info("{} logout, close session", (Object)this);
            this.apiSession.close();
            this.apiSession = null;
        }
    }

    public void setIdentityVerificationType(IdentityVerificationType identityVerificationType) {
        this.identityVerificationType = identityVerificationType;
    }

    public void setPartnerPassword(Secret partnerPassword) {
        this.partnerPassword = partnerPassword;
    }

    public void setPartnerRole(String partnerRole) {
        this.partnerRole = partnerRole;
    }

    public void setPartnerUser(String partnerUser) {
        this.partnerUser = partnerUser;
    }

    public void setSignMeApi(SignMeApiV2Ext api) {
        this.signMeApi = api;
    }

    public void setTokenCapabilites(List<TokenCapability> tokenCapabilites) {
        this.tokenCapabilites = tokenCapabilites;
    }
}

