/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signme.common;

import de.bdr.signme.api.v2.ApiSession;
import de.bdr.signme.api.v2.gen.Certificate;
import de.bdr.signme.api.v2.gen.ErrorInfo;
import de.bdr.signme.api.v2.gen.GetIdentity;
import de.bdr.signme.api.v2.gen.GetIdentityResponse;
import de.bdr.signme.api.v2.gen.IdentitySelector;
import de.bdr.signme.api.v2.gen.RedirectURLs;
import de.bdr.signme.api.v2.gen.SignMeException;
import de.bdr.signme.api.v2.gen.SignerStatus;
import de.bdr.signme.api.v2.gen.Token;
import de.bdr.signme.api.v2.gen.TokenCapability;
import de.bdr.signme.api.v2.gen.VersionAndDate;
import de.intarsys.security.algorithm.common.PpkTools;
import de.intarsys.security.algorithm.ec.EcTools;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.common.AuthenticationCanceled;
import de.intarsys.security.common.CommonSecurityException;
import de.intarsys.security.signme.activity.SignMeApiError;
import de.intarsys.security.signme.activity.SignMeGatewayError;
import de.intarsys.security.signme.common.ISignMeLevel;
import de.intarsys.security.signme.common.SignMeSealingLevel;
import de.intarsys.security.signme.common.SignMeSignatureFormat;
import de.intarsys.security.signme.common.SignMeSignatureLevel;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.format.Format;
import jakarta.ws.rs.core.UriBuilder;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignMeTools {
    private static final Logger Log = LoggerFactory.getLogger(SignMeTools.class);
    public static final String LEVEL_QESEAL = "QESEAL";
    public static final String LEVEL_BAS = "BAS";
    public static final String LEVEL_ADV = "ADV";
    public static final String LEVEL_QES = "QES";
    private static final String SIGNATURE_TYPE_DIGEST = "S_{}_DIG_{}";
    public static final String OUTCOME_CANCEL = "cancel";
    public static final String OUTCOME_FAIL = "fail";
    public static final String OUTCOME_OK = "ok";

    public static RedirectURLs createRedirectUrls(UriBuilder builder) {
        RedirectURLs redirectURLs = new RedirectURLs();
        redirectURLs.setRedirectURLOnOk(SignMeTools.createRedirectUrls(builder, OUTCOME_OK));
        redirectURLs.setRedirectURLOnFail(SignMeTools.createRedirectUrls(builder, OUTCOME_FAIL));
        redirectURLs.setRedirectURLOnCancel(SignMeTools.createRedirectUrls(builder, OUTCOME_CANCEL));
        return redirectURLs;
    }

    protected static String createRedirectUrls(UriBuilder builder, String outcome) {
        return builder.replaceQueryParam("outcome", new Object[]{outcome}).toTemplate();
    }

    public static byte[] extractSignature(byte[] encodedCms) throws CMSException {
        CMSSignedData cmsSignedData = new CMSSignedData(encodedCms);
        SignerInformationStore signers = cmsSignedData.getSignerInfos();
        SignerInformation signerInformation = (SignerInformation)signers.getSigners().iterator().next();
        byte[] plainSignature = signerInformation.getSignature();
        return plainSignature;
    }

    public static List<String> getSignatureAlgorithms(Token token, X509Certificate cert) {
        PublicKey key = cert.getPublicKey();
        if (key instanceof ECPublicKey) {
            return Collections.singletonList("1.2.840.10045.4.3.2");
        }
        if (key instanceof RSAPublicKey) {
            return Collections.singletonList("1.2.840.113549.1.1.10");
        }
        return Collections.emptyList();
    }

    public static String getSignatureCurve(Token token, X509Certificate cert) {
        return EcTools.getSignatureCurve((PublicKey)cert.getPublicKey());
    }

    public static int getSignatureKeyLength(Token token, X509Certificate cert) {
        return PpkTools.getKeyBitSize((PublicKey)cert.getPublicKey());
    }

    public static ISignMeLevel getSignatureLevel(String id) {
        for (SignMeSignatureLevel signMeSignatureLevel : SignMeSignatureLevel.values()) {
            if (!signMeSignatureLevel.getId().equals(id)) continue;
            return signMeSignatureLevel;
        }
        for (Enum enum_ : SignMeSealingLevel.values()) {
            if (!enum_.getId().equals(id)) continue;
            return enum_;
        }
        return null;
    }

    public static String getSignatureTypeDigest(ISignMeLevel signatureLevel) {
        return SignMeTools.getSignatureTypeDigest(signatureLevel, SignMeSignatureFormat.CMS_BASIC);
    }

    public static String getSignatureTypeDigest(ISignMeLevel level, SignMeSignatureFormat format) {
        return Format.simple((String)SIGNATURE_TYPE_DIGEST, (Object[])new Object[]{level.getId(), format.getId()});
    }

    public static CommonSecurityException handleError(Throwable ex) {
        Throwable t = ExceptionTools.unwrap((Throwable)ex);
        if (t instanceof CommonSecurityException) {
            return (CommonSecurityException)t;
        }
        if (ExceptionTools.isCancellation((Throwable)t)) {
            return new AuthenticationCanceled();
        }
        if (t instanceof SignMeException) {
            ErrorInfo errorInfo = ((SignMeException)t).getFaultInfo();
            String msg = errorInfo != null ? Format.simple((String)"sign-me error {}, {}", (Object[])new Object[]{errorInfo.getErrorId(), errorInfo.getErrorMessage()}) : Format.simple((String)"sign-me error ({})", (Object[])new Object[]{ExceptionTools.getMessage((Throwable)t)});
            return new SignMeApiError(msg, t);
        }
        String msg = Format.simple((String)"unexpected problem ({})", (Object[])new Object[]{ExceptionTools.getMessage((Throwable)t)});
        return new SignMeGatewayError(msg, t);
    }

    public static RuntimeException rethrowable(Throwable ex) {
        if ((ex = ExceptionTools.unwrap((Throwable)ex)) instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)ex;
            return re;
        }
        return new CompletionException(ex);
    }

    public static List<Certificate> signMeGetCertificateChain(ApiSession session, String certificateId) throws CommonSecurityException {
        try {
            return session.getCertificate(certificateId, true);
        }
        catch (Exception e) {
            throw SignMeTools.handleError(e);
        }
    }

    public static List<X509Certificate> signMeGetCertificateChain(ApiSession session, Token token) throws CommonSecurityException, CertificateException {
        String certificateId = token.getCertificateId();
        try {
            List certificateChain = session.getCertificate(certificateId, true);
            ArrayList<X509Certificate> jcaCertificates = new ArrayList<X509Certificate>();
            for (Certificate certificate : certificateChain) {
                jcaCertificates.add(SignMeTools.toIavaCertificate(certificate));
            }
            return jcaCertificates;
        }
        catch (Exception e) {
            Log.debug("signMeGetCertificates id {} failed ({})", (Object)certificateId, (Object)ExceptionTools.getMessage((Throwable)e));
            throw SignMeTools.handleError(e);
        }
    }

    public static GetIdentityResponse signMeGetIdentity(ApiSession session, String username) throws CommonSecurityException {
        try {
            Log.trace("signMeGetIdentity username {}", (Object)username);
            GetIdentity getIdentityParams = new GetIdentity();
            IdentitySelector identitySelector = new IdentitySelector();
            identitySelector.setUsername(username);
            getIdentityParams.setIdentitySelector(identitySelector);
            return session.getIdentity(getIdentityParams);
        }
        catch (Exception e) {
            Log.debug("signMeGetIdentity username {} failed ({})", (Object)username, (Object)ExceptionTools.getMessage((Throwable)e));
            throw SignMeTools.handleError(e);
        }
    }

    public static SignerStatus signMeGetSignerStatus(ApiSession session, String username, String signatureType) throws CommonSecurityException {
        try {
            return session.getSignerStatus(signatureType, username, null, null);
        }
        catch (Exception e) {
            throw SignMeTools.handleError(e);
        }
    }

    public static Optional<Token> signMeGetToken(ApiSession session, String username, List<TokenCapability> capabilities) throws CommonSecurityException {
        IdentitySelector identitySelector = new IdentitySelector();
        identitySelector.setUsername(username);
        try {
            List serverTokens = session.getTokensForIdentity(identitySelector, capabilities, null, Boolean.valueOf(true), null, null);
            return serverTokens.stream().findFirst();
        }
        catch (Exception e) {
            throw SignMeTools.handleError(e);
        }
    }

    public static Optional<Token> signMeGetToken(ApiSession session, String username, TokenCapability capability) throws CommonSecurityException {
        ArrayList<TokenCapability> havingTokenCapabilities = new ArrayList<TokenCapability>();
        havingTokenCapabilities.add(capability);
        return SignMeTools.signMeGetToken(session, username, havingTokenCapabilities);
    }

    public static Optional<Token> signMeGetToken(ApiSession session, String username, TokenCapability[] capabilities) throws CommonSecurityException {
        return SignMeTools.signMeGetToken(session, username, Arrays.asList(capabilities));
    }

    public static VersionAndDate signMeGetVersion(ApiSession session) throws CommonSecurityException {
        try {
            return session.getVersion();
        }
        catch (Exception e) {
            throw SignMeTools.handleError(e);
        }
    }

    public static X509Certificate toIavaCertificate(Certificate signMeCertificate) throws CertificateException {
        byte[] bytes = signMeCertificate.getCertificate();
        return ((IX509PublicKeyCertificate)CertificateTools.createCertificate((Object)bytes)).toJavaCertificate();
    }

    public static String trimItemName(String param) {
        if (param == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (char c : param.toCharArray()) {
            if (c >= '0' && c <= '9') {
                sb.append(c);
            } else if (c >= 'a' && c <= 'z') {
                sb.append(c);
            } else if (c >= 'A' && c <= 'Z') {
                sb.append(c);
            } else if (c == '_') {
                sb.append(c);
            } else if (c == '.') {
                sb.append(c);
            } else if (c == ',') {
                sb.append(c);
            } else if (c == '-') {
                sb.append(c);
            } else if (c == '(') {
                sb.append(c);
            } else if (c == ')') {
                sb.append(c);
            } else if (c == '~') {
                sb.append(c);
            } else if (c >= '\u0080' && c <= '\u00fe') {
                sb.append(c);
            } else {
                sb.append('_');
            }
            if (sb.length() >= 80) break;
        }
        return sb.toString();
    }

    private SignMeTools() {
    }
}

