/*
 * Decompiled with CFR 0.152.
 */
package com.cabaret.application.datetime;

import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.date.IDateEnvironment;
import de.intarsys.tools.date.StandardDateEnvironment;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.ntp.FixedDateEnvironment;
import de.intarsys.tools.ntp.NTPDateEnvironment;
import de.intarsys.tools.ntp.auth.INTPKeyMap;
import de.intarsys.tools.ntp.auth.NTPKeyFile;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableDateEnvironment
implements IPreferencesSupport,
IPreferencesSyncher,
IDateEnvironment {
    private static final Logger Log = LoggerFactory.getLogger(ConfigurableDateEnvironment.class);
    public static final String PREF_TIMESOURCE = "timeSource";
    public static final String TIMESOURCE_LOCAL = "local";
    public static final String TIMESOURCE_NET = "net";
    public static final String PREF_TIMESOURCE_NET_SERVER = "netServer";
    public static final String PREF_TIMESOURCE_NET_TIMEOUT = "netTimeout";
    public static final String PREF_TIMESOURCE_NET_DELAY = "netDelay";
    public static final String PREF_TIMESOURCE_NET_KEYFILE = "keyFile";
    private static final String SERVER_DELIMITER = "|";
    private IPreferences preferences;
    private IDateEnvironment dateEnvironment;
    private String keyFile;

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences result = root.node(name);
        IPreferences defaultPreferences = result.restrict("DEFAULT");
        this.preferencesInit(defaultPreferences);
        return result;
    }

    public IDateEnvironment getDateEnvironment() {
        if (this.dateEnvironment == null) {
            this.dateEnvironment = new StandardDateEnvironment();
        }
        return this.dateEnvironment;
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "de.intarsys.prefs.datetime";
    }

    @PostConstruct
    public void install() {
        this.preferencesRestore();
        Log.info("DateEnvironment is {}", (Object)this);
        Log.info("+- System.currentTimeMillis() {}", (Object)System.currentTimeMillis());
        Log.info("+- DateEnvironment.now() {}", (Object)this.now().getTime());
    }

    public Date now() {
        return this.getDateEnvironment().now();
    }

    protected void preferencesInit(IPreferences preferences) {
        preferences.put(PREF_TIMESOURCE, TIMESOURCE_LOCAL);
        preferences.put(PREF_TIMESOURCE_NET_DELAY, 60000);
        preferences.put(PREF_TIMESOURCE_NET_TIMEOUT, 1000);
        preferences.put(PREF_TIMESOURCE_NET_KEYFILE, new File(FileEnvironment.get().getProfileDir(), "ntpkey.txt").getAbsolutePath());
    }

    public void preferencesRestore() {
        IPreferences preferences = this.getPreferences();
        String source = preferences.get(PREF_TIMESOURCE);
        if (TIMESOURCE_NET.equals(source)) {
            FileLocator keyFileLocator;
            NTPDateEnvironment ntpDateEnvironment = new NTPDateEnvironment();
            ntpDateEnvironment.setDefaultTimeout(preferences.getInt(PREF_TIMESOURCE_NET_TIMEOUT));
            String serverString = preferences.get(PREF_TIMESOURCE_NET_SERVER);
            if (!StringTools.isEmpty((String)serverString)) {
                StringTokenizer st = new StringTokenizer(serverString, SERVER_DELIMITER);
                while (st.hasMoreTokens()) {
                    String server = st.nextToken();
                    if (StringTools.isEmpty((String)server)) continue;
                    ntpDateEnvironment.addServer(server);
                }
            }
            this.keyFile = preferences.get(PREF_TIMESOURCE_NET_KEYFILE);
            if (this.keyFile != null && (keyFileLocator = new FileLocator(this.keyFile)).exists()) {
                try {
                    NTPKeyFile keyMap = NTPKeyFile.createFromLocator((ILocator)keyFileLocator);
                    ntpDateEnvironment.setKeyMap((INTPKeyMap)keyMap);
                }
                catch (IOException e) {
                    Log.warn("Error loading NTP key file: " + e.getMessage(), (Throwable)e);
                }
            }
            ntpDateEnvironment.setDefaultTimeout(preferences.getInt(PREF_TIMESOURCE_NET_TIMEOUT));
            long delay = preferences.getLong(PREF_TIMESOURCE_NET_DELAY);
            if (delay > 0L) {
                FixedDateEnvironment fixedDateEnvironment = new FixedDateEnvironment();
                fixedDateEnvironment.setDelay(delay);
                fixedDateEnvironment.setReferenceTimeProvider((IDateEnvironment)ntpDateEnvironment);
                this.setDateEnvironment((IDateEnvironment)fixedDateEnvironment);
            } else {
                this.setDateEnvironment((IDateEnvironment)ntpDateEnvironment);
            }
        } else {
            this.setDateEnvironment((IDateEnvironment)new StandardDateEnvironment());
        }
    }

    public void preferencesStore() {
        IPreferences preferences = this.getPreferences();
        String source = TIMESOURCE_LOCAL;
        IDateEnvironment dateEnvironment = this.getDateEnvironment();
        if (dateEnvironment instanceof FixedDateEnvironment) {
            FixedDateEnvironment fixedDateEnvironment = (FixedDateEnvironment)dateEnvironment;
            preferences.put(PREF_TIMESOURCE_NET_DELAY, fixedDateEnvironment.getDelay());
            dateEnvironment = fixedDateEnvironment.getReferenceTimeProvider();
        }
        if (dateEnvironment instanceof NTPDateEnvironment) {
            NTPDateEnvironment ntpDateEnvironment = (NTPDateEnvironment)dateEnvironment;
            StringBuilder serverString = new StringBuilder();
            Iterator i = ntpDateEnvironment.getServers().iterator();
            while (i.hasNext()) {
                NTPDateEnvironment.Server server = (NTPDateEnvironment.Server)i.next();
                serverString.append(server.toString());
                if (!i.hasNext()) continue;
                serverString.append(SERVER_DELIMITER);
            }
            preferences.put(PREF_TIMESOURCE_NET_SERVER, serverString.toString());
            preferences.put(PREF_TIMESOURCE_NET_TIMEOUT, ntpDateEnvironment.getDefaultTimeout());
            preferences.put(PREF_TIMESOURCE_NET_KEYFILE, this.keyFile);
            source = TIMESOURCE_NET;
        }
        preferences.put(PREF_TIMESOURCE, source);
    }

    public void setDateEnvironment(IDateEnvironment dateEnvironment) {
        if (this.dateEnvironment instanceof IStartStop) {
            ((IStartStop)this.dateEnvironment).stop();
        }
        this.dateEnvironment = dateEnvironment;
        if (this.dateEnvironment instanceof IStartStop) {
            ((IStartStop)this.dateEnvironment).start();
        }
    }

    @PreDestroy
    public void uninstall() {
        this.preferencesStore();
    }
}

