/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tsa;

import de.intarsys.security.tsa.ISerialNumberGenerator;
import de.intarsys.security.tsa.ITSA;
import de.intarsys.security.tsa.TSATools;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import java.math.BigInteger;

public class IncrementalSerialNumberGenerator
implements ISerialNumberGenerator,
IElementConfigurable,
IElementSerializable,
IContextSupport {
    private BigInteger serialNumber;
    private Object context;

    public void configure(IElement element) throws ConfigurationException {
        String value = element.attributeValue("value", null);
        this.setCurrent(new BigInteger(value));
    }

    public Object getContext() {
        return this.context;
    }

    public BigInteger getCurrent() {
        if (this.serialNumber == null) {
            this.serialNumber = BigInteger.ONE;
        }
        return this.serialNumber;
    }

    @Override
    public synchronized BigInteger next() {
        BigInteger current = this.getCurrent();
        this.setCurrent(current.add(BigInteger.ONE));
        if (this.getContext() instanceof ITSA) {
            TSATools.extensionUpdateTSA((ITSA)this.getContext());
        }
        return current;
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("class", this.getClass().getName());
        element.setAttributeValue("value", this.getCurrent().toString());
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public void setCurrent(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
    }
}

