/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tsa;

import de.intarsys.security.tsa.ISerialNumberGenerator;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RandomSerialNumberGenerator
implements ISerialNumberGenerator,
IElementConfigurable,
IElementSerializable {
    private SecureRandom rng;
    private int size = 20;

    public void configure(IElement element) throws ConfigurationException {
        this.setSize(ElementTools.getInt((IElement)element, (String)"size", (int)20));
    }

    protected synchronized SecureRandom getRng() {
        if (this.rng == null) {
            this.rng = CryptoTools.createSecureRandom();
        }
        return this.rng;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public synchronized BigInteger next() {
        byte[] serialNumberBytes = new byte[this.getSize()];
        this.getRng().nextBytes(serialNumberBytes);
        return new BigInteger(serialNumberBytes);
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("class", this.getClass().getName());
        element.setAttributeValue("size", String.valueOf(this.getSize()));
    }

    public void setSize(int size) {
        this.size = size;
    }
}

