/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tsa;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ArgumentDeclarator;
import de.intarsys.tools.functor.DeclarationBlock;
import de.intarsys.tools.functor.DeclarationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.common.DeclarationIO;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.reflect.ObjectCreationException;

public class SignatureProfile
implements IElementConfigurable,
IElementSerializable {
    private IDeclarationBlock declarationBlock;
    private IArgs args;

    public void configure(IElement element) throws ConfigurationException {
        IDeclarationBlock declarationBlock = this.getDeclarationBlock();
        if (element.element("declarations") != null) {
            declarationBlock.clear();
            try {
                new DeclarationIO().deserializeDeclarationBlock(declarationBlock, element);
            }
            catch (ObjectCreationException e) {
                throw new ConfigurationException();
            }
        }
    }

    public IArgs getArgs() {
        if (this.args == null) {
            Args args = Args.create();
            IDeclarationBlock declarations = this.getDeclarationBlock();
            ArgumentDeclarator declarator = new ArgumentDeclarator();
            try {
                declarator.apply(declarations, (IArgs)args);
            }
            catch (DeclarationException e) {
                throw new IllegalArgumentException(e);
            }
            this.args = args;
        }
        return this.args;
    }

    public IDeclarationBlock getDeclarationBlock() {
        if (this.declarationBlock == null) {
            this.declarationBlock = new DeclarationBlock((Object)this);
        }
        return this.declarationBlock;
    }

    public void serialize(IElement element) throws ElementSerializationException {
        new DeclarationIO().serializeDeclarationBlock(this.getDeclarationBlock(), element);
    }

    public void setDeclarationBlock(IDeclarationBlock declarations) {
        this.declarationBlock = declarations;
    }
}

