/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tsa;

import de.intarsys.security.tsa.ITSA;
import de.intarsys.security.tsa.ITSARegistry;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import java.util.ArrayList;
import java.util.List;

public class StandardTSARegistry
implements ITSARegistry,
INotificationSupport {
    private final List<ITSA> tsas;
    private final EventDispatcher dispatcher = new EventDispatcher((Object)this);

    public StandardTSARegistry() {
        this.tsas = new ArrayList<ITSA>();
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    @Override
    public ITSA[] getTSAs() {
        return this.tsas.toArray(new ITSA[this.tsas.size()]);
    }

    @Override
    public ITSA lookupTSA(String id) {
        if (id == null) {
            return null;
        }
        for (ITSA object : this.tsas) {
            if (!id.equals(object.getId())) continue;
            return object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTSA(ITSA tsa) {
        StandardTSARegistry standardTSARegistry = this;
        synchronized (standardTSARegistry) {
            this.unregisterTSA(this.lookupTSA(tsa.getId()));
            this.tsas.add(tsa);
        }
        this.triggerChanged("tsas", null, tsa);
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, attribute, oldValue, newValue);
        this.triggerEvent((Event)event);
    }

    protected void triggerEvent(Event event) {
        this.dispatcher.triggerEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterTSA(ITSA ca) {
        boolean changed;
        StandardTSARegistry standardTSARegistry = this;
        synchronized (standardTSARegistry) {
            changed = this.tsas.remove(ca);
        }
        if (changed) {
            this.triggerChanged("tsas", ca, null);
        }
    }
}

