/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tsa;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.common.GeneralName;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.rfc3161.MessageImprint;
import de.intarsys.asn1.rfc3161.TSTInfo;
import de.intarsys.asn1.rfc3161.TimeStampReq;
import de.intarsys.asn1.rfc3161.TimeStampResp;
import de.intarsys.asn1.x509.Name;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.signature.SignerTools;
import de.intarsys.security.app.timestamp.ITimestampRequest;
import de.intarsys.security.app.timestamp.ITimestampResponse;
import de.intarsys.security.app.timestamp.PlainTimestampRequest;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.digest.DigestTools;
import de.intarsys.security.method.cms.signature.CMSSignatureContainer;
import de.intarsys.security.method.cms.signature.CMSSignatureContainerBuilder;
import de.intarsys.security.method.cms.signature.CMSSignatureContainerBuilderFactoryGeneric;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.processor.signature.CommonDocumentSigner;
import de.intarsys.security.tsa.CommonTSA;
import de.intarsys.security.tsa.ISerialNumberGenerator;
import de.intarsys.security.tsa.RandomSerialNumberGenerator;
import de.intarsys.security.tsa.SignatureProfile;
import de.intarsys.security.tsa.TSAFactory;
import de.intarsys.security.tsa.rfc3161.RFC3161TimestampRequest;
import de.intarsys.security.tsa.rfc3161.RFC3161TimestampResponse;
import de.intarsys.tools.collection.IterableTools;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.driver.ConversationDriver;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.factory.FactoredBy;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

@FactoredBy(factory=TSAFactory.class)
public class TSA
extends CommonTSA {
    public static String[] DIGEST_ALGORITHMS = new String[]{"MD5", "RIPEMD160", "RIPEMD256", "SHA-1", "SHA-224", "SHA-256", "SHA-384", "SHA-512"};
    private ISerialNumberGenerator serialNumberGenerator;
    private SignatureProfile signatureProfile;
    private String policyId = "1.3.6.1.4.1.8291.1.1";
    private List<String> acceptableHashAlgorithms;
    private IArgs args;

    public TSA() {
    }

    public TSA(String id) {
        super(id);
    }

    protected void checkHashAlgorithm(String hashAlgorithmName) throws SecurityApplicationException {
        List<String> acceptable = this.getAcceptableHashAlgorithmNames();
        if (!DigestAlgorithm.contains(acceptable, (String)hashAlgorithmName)) {
            throw new SecurityApplicationException("Digest algorithm " + hashAlgorithmName + " is not accepted by TSA.");
        }
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        IElement eSignatureProfile = element.element("signatureProfile");
        if (eSignatureProfile != null) {
            SignatureProfile profile = new SignatureProfile();
            profile.configure(eSignatureProfile);
            this.setSignatureProfile(profile);
        }
        IElement eSerialNumberGenerator = element.element("serialNumberGenerator");
        try {
            this.setSerialNumberGenerator((ISerialNumberGenerator)ElementTools.createObject((IElement)eSerialNumberGenerator, ISerialNumberGenerator.class, (Object)this, (IArgs)Args.create()));
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException((Throwable)e);
        }
        this.setPolicyId(ElementTools.getString((IElement)element, (String)"policyId", (String)this.getPolicyId()));
        IElement eAcceptableDigestAlgorithms = element.element("acceptableDigestAlgorithms");
        if (eAcceptableDigestAlgorithms != null) {
            this.acceptableHashAlgorithms = new ArrayList<String>();
            for (IElement eAlgorithm : IterableTools.in((Iterator)eAcceptableDigestAlgorithms.elementIterator("algorithm"))) {
                DigestAlgorithm hashAlgorithm;
                String hashAlgorithmName = eAlgorithm.attributeValue("name", null);
                if (StringTools.isEmpty((String)hashAlgorithmName)) {
                    hashAlgorithmName = eAlgorithm.attributeValue("oid", null);
                }
                if ((hashAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)hashAlgorithmName)) == null) {
                    throw new ConfigurationException("name or oid attribute required for algorithm");
                }
                this.acceptableHashAlgorithms.add(hashAlgorithmName);
            }
        }
    }

    @Override
    public ITimestampResponse createTimestamp(ITimestampRequest request) throws SecurityApplicationException {
        if ("RFC3161".equals(request.getFormat())) {
            TimeStampReq timeStampReq;
            try {
                timeStampReq = ((RFC3161TimestampRequest)request).getTimeStampReq();
            }
            catch (IOException e) {
                throw new SecurityApplicationException((Throwable)e);
            }
            TimeStampResp timeStampResp = this.createTimestamp(timeStampReq);
            return new RFC3161TimestampResponse(timeStampResp);
        }
        if ("plain".equals(request.getFormat())) {
            TimeStampResp timeStampResp = this.createTimestamp((PlainTimestampRequest)request);
            return new RFC3161TimestampResponse(timeStampResp);
        }
        throw new SecurityApplicationException("Unsupported request format: " + request.getFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TimeStampResp createTimestamp(PlainTimestampRequest request) throws SecurityApplicationException {
        IDigest digest = request.getDigest();
        String hashAlg = digest.getAlgorithmName();
        this.checkHashAlgorithm(hashAlg);
        MessageImprint messageImprint = (MessageImprint)MessageImprint.FACTORY.createNew();
        String hashAlgOid = DigestAlgorithm.lookupOID((String)hashAlg);
        messageImprint.setHashAlgorithm(AlgorithmIdentifier.create((String)hashAlgOid));
        messageImprint.setHashedMessage(digest.getBytes());
        ISigner digestSigner = this.getDigestSigner();
        try {
            TSTInfo tstInfo = this.createTSTInfo(messageImprint, null, digestSigner);
            CMS timestampToken = this.createTimestampToken(tstInfo, digestSigner, true);
            TimeStampResp timeStampResp = (TimeStampResp)TimeStampResp.FACTORY.createNew();
            timeStampResp.setTimeStampToken(timestampToken);
            timeStampResp.setStatus(new PKIStatusInfo(PKIStatus.granted));
            TimeStampResp timeStampResp2 = timeStampResp;
            return timeStampResp2;
        }
        finally {
            digestSigner.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TimeStampResp createTimestamp(TimeStampReq request) throws SecurityApplicationException {
        MessageImprint messageImprint = request.getMessageImprint();
        String hashAlgOid = messageImprint.getHashAlgorithm().getAlgorithm();
        this.checkHashAlgorithm(hashAlgOid);
        ISigner digestSigner = this.getDigestSigner();
        try {
            TSTInfo tstInfo = this.createTSTInfo(messageImprint, request.getNonce(), digestSigner);
            CMS timestampToken = this.createTimestampToken(tstInfo, digestSigner, request.isCertReq());
            TimeStampResp timeStampResp = (TimeStampResp)TimeStampResp.FACTORY.createNew();
            timeStampResp.setTimeStampToken(timestampToken);
            timeStampResp.setStatus(new PKIStatusInfo(PKIStatus.granted));
            TimeStampResp timeStampResp2 = timeStampResp;
            return timeStampResp2;
        }
        finally {
            digestSigner.dispose();
        }
    }

    protected CMS createTimestampToken(TSTInfo tstInfo, ISigner digestSigner, boolean certReq) throws SecurityApplicationException {
        try {
            IArgs tmpArgs = this.getArgs().copy();
            byte[] encTstInfo = tstInfo.getDEREncoded();
            ByteArrayLocator tstInfoLocator = new ByteArrayLocator(encTstInfo, "TSTInfo", "unknown");
            IDigester digester = DigestTools.getDigesterOrSha1((IArgs)tmpArgs, (String)"SHA-256", (Collection)CommonDocumentSigner.DIGEST_ALGORITHMS_ALL);
            IDigest tstInfoDigest = digester.digest(encTstInfo);
            tmpArgs.put("signer", (Object)digestSigner);
            tmpArgs.put("includeCertificates", (Object)certReq);
            tmpArgs.put("hash", (Object)tstInfoDigest);
            tmpArgs.put("content", (Object)tstInfoLocator);
            tmpArgs.put("contentType", (Object)PKCSObjectIdentifiers.id_ct_TSTInfo);
            IFactory factory = CMSSignatureContainerBuilder.getFactory((IArgs)tmpArgs, (Object)CMSSignatureContainerBuilderFactoryGeneric.get());
            ICMSSignatureContainerBuilder builder = (ICMSSignatureContainerBuilder)factory.createInstance(tmpArgs);
            IConversation conversation = builder.run();
            CMSSignatureContainer p7Container = (CMSSignatureContainer)ConversationDriver.get().get(conversation);
            return p7Container.getCms();
        }
        catch (Exception e) {
            throw new SecurityApplicationException((Throwable)e);
        }
    }

    protected TSTInfo createTSTInfo(MessageImprint messageImprint, BigInteger nonce, ISigner signer) throws SecurityApplicationException {
        IX509PublicKeyCertificate[] certs;
        IX509PublicKeyCertificate certificate;
        Date time = this.getTime();
        BigInteger serial = this.getSerialNumberGenerator().next();
        ASN1GeneralizedTime genTime = new ASN1GeneralizedTime(time);
        TSTInfo tstInfo = (TSTInfo)TSTInfo.FACTORY.createNew();
        tstInfo.setVersion(1);
        tstInfo.setTSAPolicyId(this.getPolicyId());
        tstInfo.setMessageImprint(messageImprint);
        tstInfo.setSerialNumber(serial);
        tstInfo.setGenTime(genTime);
        if (nonce != null) {
            tstInfo.setNonce(nonce);
        }
        IX509PublicKeyCertificate iX509PublicKeyCertificate = certificate = (certs = signer.getCertificatePath()) == null || certs.length == 0 ? null : certs[0];
        if (certificate != null) {
            ASN1Primitive asn1Subject;
            try {
                asn1Subject = ASN1Tools.create((byte[])certificate.getSubjectX500Principal().getEncoded());
            }
            catch (IOException e) {
                throw new SecurityApplicationException((Throwable)e);
            }
            GeneralName tsa = new GeneralName();
            tsa.setDirectoryName((Name)Name.FACTORY.create((ASN1Encodable)asn1Subject));
            tstInfo.setTsa(tsa);
        }
        return tstInfo;
    }

    public List<String> getAcceptableHashAlgorithmNames() {
        if (this.acceptableHashAlgorithms == null) {
            this.acceptableHashAlgorithms = ListTools.with((Object[])DIGEST_ALGORITHMS);
        }
        return new ArrayList<String>(this.acceptableHashAlgorithms);
    }

    public IArgs getArgs() {
        return this.args;
    }

    protected ISigner getDigestSigner() throws SecurityApplicationException {
        try {
            return SignerTools.getSigner((IArgs)this.getArgs(), (String)"digestSigner");
        }
        catch (ObjectCreationException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public ISerialNumberGenerator getSerialNumberGenerator() {
        if (this.serialNumberGenerator == null) {
            this.serialNumberGenerator = new RandomSerialNumberGenerator();
        }
        return this.serialNumberGenerator;
    }

    public SignatureProfile getSignatureProfile() {
        return this.signatureProfile;
    }

    protected Date getTime() {
        return DateEnvironment.get().now();
    }

    @PostConstruct
    public void init() {
        Args finalArgs = Args.create();
        if (this.getSignatureProfile() != null) {
            ArgTools.putAllDeep((IArgs)finalArgs, (IArgs)this.getSignatureProfile().getArgs());
        }
        if (this.getArgs() != null) {
            ArgTools.putAllDeep((IArgs)finalArgs, (IArgs)this.getArgs());
        }
        this.setArgs((IArgs)finalArgs);
        if (ArgTools.getPath((IArgs)this.getArgs(), (String)"digestSigner") == null) {
            ArgTools.putPath((IArgs)this.getArgs(), (String)"digestSigner.factory", (Object)"de.intarsys.security.app.signature.SignerFactory");
            ArgTools.putPath((IArgs)this.getArgs(), (String)"digestSigner.args.device", (Object)"default@demo");
        }
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        super.serialize(element);
        if (this.getSignatureProfile() != null) {
            IElement eSignatureProfile = element.newElementMapped("signatureProfile");
            this.getSignatureProfile().serialize(eSignatureProfile);
        }
        if (this.serialNumberGenerator != null) {
            ElementTools.putObject((IElement)element, (String)"serialNumberGenerator", (Object)this.serialNumberGenerator);
        }
        element.setAttributeValue("policyId", this.getPolicyId());
        if (this.acceptableHashAlgorithms != null) {
            IElement eAcceptableDigestAlgorithms = element.newElementMapped("acceptableDigestAlgorithms");
            for (String algorithmName : this.getAcceptableHashAlgorithmNames()) {
                IElement eAlgorithm = eAcceptableDigestAlgorithms.newElementMapped("algorithm");
                eAlgorithm.setAttributeValue("name", algorithmName);
            }
        }
    }

    public void setAcceptableHashAlgorithms(List<String> acceptableDigestAlgorithms) {
        this.acceptableHashAlgorithms = acceptableDigestAlgorithms;
    }

    public void setArgs(IArgs args) {
        this.args = args;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public void setSerialNumberGenerator(ISerialNumberGenerator serialNumberGenerator) {
        this.serialNumberGenerator = serialNumberGenerator;
    }

    public void setSignatureProfile(SignatureProfile profile) {
        this.signatureProfile = profile;
    }
}

