/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tsa;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.impl.ExtensionOperation;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.security.tsa.ITSA;
import de.intarsys.security.tsa.TSARegistry;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TSAInstaller
extends ExtensionPointHandlerAdapter {
    private static final Logger Log = LoggerFactory.getLogger(TSAInstaller.class);
    public static final String XE_TSA = "tsa";
    protected static final String SERIALIZE_EXTENSIONPOINT = "de.intarsys.security.tsa";
    protected static final String SERIALIZE_INSTRUMENT = "update.de.intarsys.stage.security.tsa";

    protected List<ExtensionOperation> basicGetAttachments(IExtension extension) {
        List tempList = super.basicGetAttachments(extension);
        Collections.sort(tempList, new Comparator<ExtensionOperation>(){

            @Override
            public int compare(ExtensionOperation o1, ExtensionOperation o2) {
                if (o1.getObject() instanceof ITSA) {
                    return -1;
                }
                return 1;
            }
        });
        return tempList;
    }

    protected Object basicInstallDelete(IExtension extension, IElement element) {
        if (XE_TSA.equals(element.getName())) {
            String id = element.attributeValue("id", null);
            ITSA object = TSARegistry.get().lookupTSA(id);
            TSARegistry.get().unregisterTSA(object);
            return object;
        }
        return super.basicInstallDelete(extension, element);
    }

    protected Object basicInstallInsert(IExtension extension, IElement element) {
        if (XE_TSA.equals(element.getName())) {
            try {
                ITSA ca = (ITSA)ElementTools.createObject((IElement)element, ITSA.class, (Object)extension.getProvider(), (IArgs)Args.create());
                TSARegistry.get().registerTSA(ca);
                return ca;
            }
            catch (ObjectCreationException e) {
                String msg = "error creating tsa";
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
        } else {
            return super.basicInstallInsert(extension, element);
        }
        return null;
    }

    protected Object basicInstallUpdate(IExtension extension, IElement element) {
        if (XE_TSA.equals(element.getName())) {
            try {
                String id = element.attributeValue("id", null);
                ITSA ca = TSARegistry.get().lookupTSA(id);
                if (ca == null) {
                    String msg = "no tsa with id " + id;
                    this.log(Log, Level.ERROR, extension, element, msg, null);
                    return null;
                }
                if (ca instanceof IElementConfigurable) {
                    ((IElementConfigurable)ca).configure(element);
                }
                return ca;
            }
            catch (Exception e) {
                String msg = "error creating tsa";
                this.log(Log, Level.ERROR, extension, element, msg, e);
            }
        } else {
            return super.basicInstallUpdate(extension, element);
        }
        return null;
    }
}

