/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tsa;

import de.intarsys.claptz.IInstrument;
import de.intarsys.claptz.IInstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistry;
import de.intarsys.claptz.InstrumentTools;
import de.intarsys.claptz.io.DirectoryInstrumentStore;
import de.intarsys.claptz.io.IInstrumentStore;
import de.intarsys.security.tsa.CommonTSA;
import de.intarsys.security.tsa.ITSA;
import de.intarsys.security.tsa.PACKAGE;
import de.intarsys.security.tsa.TSARegistry;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;

public class TSATools {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public static ITSA copyCA(ITSA object) {
        try {
            IElement tempElement = ElementFactory.get().createElement("tsa");
            IDocument tempDocument = ElementFactory.get().createDocument();
            ((IStringEvaluatorAccess)tempDocument).setStringEvaluator(ExpressionEvaluator.get((Mode)Mode.UNTRUSTED));
            tempDocument.setRootElement(tempElement);
            ((IElementSerializable)object).serialize(tempElement);
            tempElement.setAttributeValue("id", null);
            CommonTSA copy = (CommonTSA)ElementTools.createObject((IElement)tempElement, CommonTSA.class, (Object)object.getClass().getClassLoader(), (IArgs)Args.create());
            copy.setPersistent(false);
            String baseId = Msg.getString("TSATools.copyPrefix", new Object[0]) + " " + object.getId();
            copy.setId(TSATools.createCAId(baseId));
            return copy;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String createCAId(String baseName) {
        if (StringTools.isEmpty((String)baseName)) {
            baseName = Msg.getString("TSATools.newTSA.label", new Object[0]);
        }
        Object id = baseName;
        int index = 2;
        while (TSATools.isCAIdUsed((String)id)) {
            id = baseName + " " + index++;
        }
        return id;
    }

    public static void extensionDeleteTSA(ITSA object) {
        try {
            IInstrument provider = InstrumentTools.lookupOrCreateInstrument((IInstrumentRegistry)InstrumentRegistry.get(), (String)"update.de.intarsys.stage.security.tsa", (IInstrumentStore)DirectoryInstrumentStore.getLocal());
            InstrumentTools.objectDelete((IInstrument)provider, (String)"de.intarsys.security.tsa", (Object)object);
            provider.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void extensionInsertTSA(ITSA object) {
        try {
            IInstrument provider = InstrumentTools.lookupOrCreateInstrument((IInstrumentRegistry)InstrumentRegistry.get(), (String)"update.de.intarsys.stage.security.tsa", (IInstrumentStore)DirectoryInstrumentStore.getLocal());
            InstrumentTools.objectInsert((IInstrument)provider, (String)"de.intarsys.security.tsa", (Object)object);
            provider.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void extensionUpdateTSA(ITSA object) {
        try {
            IInstrument provider = InstrumentTools.lookupOrCreateInstrument((IInstrumentRegistry)InstrumentRegistry.get(), (String)"update.de.intarsys.stage.security.tsa", (IInstrumentStore)DirectoryInstrumentStore.getLocal());
            InstrumentTools.objectUpdate((IInstrument)provider, (String)"de.intarsys.security.tsa", (Object)object);
            provider.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static boolean isCAIdUsed(String id) {
        for (ITSA container : TSARegistry.get().getTSAs()) {
            if (!container.getId().equals(id)) continue;
            return true;
        }
        return false;
    }
}

