/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.certificate;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.provider.keystore.KeyStoreCertificateProvider;
import de.intarsys.security.certificate.provider.keystore.KeyStoreCertificateProviderFactoryBean;
import de.intarsys.security.device.DeviceTools;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IX509Principal;
import de.intarsys.security.device.common.CommonDeviceProvider;
import de.intarsys.security.device.keystore.device.KeystoreDevice;
import de.intarsys.security.device.keystore.device.KeystoreDeviceProvider;
import de.intarsys.security.environment.SecurityEnvironment;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ClassResourceLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"builtinkeystore"})
public class GearsCertificateConfiguration {
    private static final Logger Log = LoggerFactory.getLogger(GearsCertificateConfiguration.class);

    @Bean
    public IDevice builtInDevice() throws Exception {
        String id = "builtin";
        Secret secret = Secret.parse((String)"plain#WTB1TExOM3YzcktuMHc=");
        CommonDeviceProvider deviceProvider = (CommonDeviceProvider)DeviceTools.lookupDeviceProvider(KeystoreDeviceProvider.class);
        if (deviceProvider == null) {
            throw new ObjectCreationException("cannot create device '" + id + "', device provider missing");
        }
        KeyStoreCertificateProviderFactoryBean factory = new KeyStoreCertificateProviderFactoryBean();
        factory.setKeyStoreLocator((ILocator)new ClassResourceLocator(GearsCertificateConfiguration.class, "builtin.keystore"));
        factory.setKeyStorePassword(secret);
        factory.afterPropertiesSet();
        KeyStoreCertificateProvider certificateProvider = (KeyStoreCertificateProvider)factory.getObject();
        Args args = Args.create();
        args.put("id", (Object)id);
        args.put("certificateProvider", (Object)certificateProvider);
        Log.info("{}, create instance", (Object)id);
        KeystoreDevice device = (KeystoreDevice)deviceProvider.createInstance((IArgs)args);
        Iterator i = device.listPrincipals(null);
        while (i.hasNext()) {
            IPrincipal principal = (IPrincipal)i.next();
            if (!(principal instanceof IX509Principal) || !((IX509Principal)principal).isKeyOwner()) continue;
            IX509PublicKeyCertificate cert = ((IX509Principal)principal).getX509PublicKeyCertificate();
            String certId = CertificateTools.getUniqueIdentifier((IX509PublicKeyCertificate)cert);
            SecurityEnvironment.get().setSecret(certId, secret, false);
        }
        return device;
    }

    @PostConstruct
    public void init() {
    }
}

