/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.keystore.db;

import de.intarsys.model.common.security.Certificate;
import de.intarsys.model.common.security.Key;
import de.intarsys.model.common.security.KeyRef;
import de.intarsys.model.common.security.KeyRefRepository;
import de.intarsys.model.common.security.KeyRepository;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certstore.store.db.manage.CertificateLibrarian;
import de.intarsys.security.device.key.CommonKeyStore;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreTools;
import de.intarsys.security.virtualkeystore.db.IPrivateKeyProtection;
import de.intarsys.tools.crypto.Secret;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.Optional;

public class GearsDBKeyStore
extends CommonKeyStore {
    private CertificateLibrarian certificateLibrarian;
    private IPrivateKeyProtection privateKeyProtection;
    private KeyRepository keyRepository;
    private KeyRefRepository keyRefRepository;

    public void delete(IX509PublicKeyCertificate certificate) throws SecurityApplicationException {
        try {
            Certificate dbCertificate = DBKeyStoreTools.getDBCertificate((IX509Certificate)certificate);
            Optional keyRef = this.keyRefRepository.findByCertificate(dbCertificate);
            if (!keyRef.isPresent()) {
                throw new SecurityApplicationException("Cannot find keyref");
            }
            this.certificateLibrarian.deleteKey((KeyRef)keyRef.get());
            this.keyRefRepository.delete((Object)((KeyRef)keyRef.get()));
        }
        catch (Exception e) {
            throw new SecurityApplicationException((Throwable)e);
        }
    }

    public CertificateLibrarian getCertificateLibrarian() {
        return this.certificateLibrarian;
    }

    public KeyRefRepository getKeyRefRepository() {
        return this.keyRefRepository;
    }

    public KeyRepository getKeyRepository() {
        return this.keyRepository;
    }

    public IPrivateKeyProtection getPrivateKeyProtection() {
        return this.privateKeyProtection;
    }

    public boolean isDeleteSupported() {
        return true;
    }

    public boolean isStoreSupported() {
        return true;
    }

    public void setCertificateLibrarian(CertificateLibrarian certificateLibrarian) {
        this.certificateLibrarian = certificateLibrarian;
    }

    public void setKeyRefRepository(KeyRefRepository keyRefRepository) {
        this.keyRefRepository = keyRefRepository;
    }

    public void setKeyRepository(KeyRepository keyRepository) {
        this.keyRepository = keyRepository;
    }

    public void setPrivateKeyProtection(IPrivateKeyProtection privateKeyProtection) {
        this.privateKeyProtection = privateKeyProtection;
    }

    public void store(IX509PublicKeyCertificate certificate, KeyPair keyPair, Secret password) throws SecurityApplicationException {
        try {
            Certificate dbCert = DBKeyStoreTools.createDBCertificate((IX509Certificate)certificate);
            Key dbKey = DBKeyStoreTools.createDBKey((PrivateKey)keyPair.getPrivate(), (Secret)password, (IPrivateKeyProtection)this.getPrivateKeyProtection());
            this.keyRepository.save((Object)dbKey);
            KeyRef keyRef = DBKeyStoreTools.createDBKeyRef((String)DBKeyStoreTools.createDBKeyRefUri((Key)dbKey), (Certificate)dbCert);
            this.keyRefRepository.save((Object)keyRef);
            this.certificateLibrarian.addKey(keyRef);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
    }
}

