/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.webhook.authenticator;

import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.webhook.api.WebhookExecutionException;
import de.intarsys.tools.webhook.authenticator.CommonWebhookAuthenticator;
import jakarta.ws.rs.client.Invocation;
import java.security.GeneralSecurityException;

public class ApiTokenAuthenticator
extends CommonWebhookAuthenticator {
    private Secret token;

    public ApiTokenAuthenticator() {
    }

    public ApiTokenAuthenticator(Secret token) {
        this.token = token;
    }

    public Secret getToken() {
        return this.token;
    }

    @Override
    public void process(Invocation.Builder builder) throws WebhookExecutionException {
        try {
            builder.header("Authorization", (Object)("Bearer " + this.getToken().getString()));
        }
        catch (GeneralSecurityException e) {
            throw new WebhookExecutionException(e);
        }
    }

    public void setToken(Secret token) {
        this.token = token;
    }
}

