/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.webhook.authenticator;

import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.webhook.api.WebhookExecutionException;
import de.intarsys.tools.webhook.authenticator.CommonWebhookAuthenticator;
import jakarta.ws.rs.client.Invocation;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;

public class BasicAuthAuthenticator
extends CommonWebhookAuthenticator {
    private String user;
    private Secret password;

    public BasicAuthAuthenticator() {
    }

    public BasicAuthAuthenticator(String user, Secret password) {
        this.user = user;
        this.password = password;
    }

    protected String createBasicToken(String user, String password) {
        return Base64.getEncoder().encodeToString((user + ":" + password).getBytes(StandardCharsets.ISO_8859_1));
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.user;
    }

    @Override
    public void process(Invocation.Builder builder) throws WebhookExecutionException {
        try {
            builder.header("Authorization", (Object)("Basic " + this.createBasicToken(this.user, this.password.getString())));
        }
        catch (GeneralSecurityException e) {
            throw new WebhookExecutionException(e);
        }
    }

    public void setPassword(Secret password) {
        this.password = password;
    }

    public void setUser(String user) {
        this.user = user;
    }
}

