/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.webhook.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import de.intarsys.tools.collection.MapTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.jaxrs.logging.LoggingFeature;
import de.intarsys.tools.ssl.ISslContextProvider;
import de.intarsys.tools.ssl.SslContextProvider;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.webhook.api.IWebhookAuthenticator;
import de.intarsys.tools.webhook.api.IWebhookStub;
import de.intarsys.tools.webhook.api.WebhookConfigurationException;
import de.intarsys.tools.webhook.api.WebhookException;
import de.intarsys.tools.webhook.api.WebhookExecutionException;
import de.intarsys.tools.webhook.api.WebhookRegistry;
import jakarta.annotation.PostConstruct;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ContextResolver;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardWebhookStub
implements IWebhookStub {
    private static final Logger Log = LoggerFactory.getLogger(StandardWebhookStub.class);
    private long connectTimeout = -1L;
    private long readTimeout = -1L;
    private String id;
    private String endpointUrl;
    private Secret secret;
    private Client client;
    private boolean followRedirects = false;
    private boolean swallowExceptions = true;
    private WebhookException exception;
    private String method = "GET";
    private WebTarget target;
    private boolean async = false;
    private ObjectMapper objectMapper;
    private IWebhookAuthenticator authenticator;
    private ISslContextProvider sslContextProvider;

    protected Client createClient() throws WebhookException {
        try {
            JacksonJsonProvider jacksonProvider = new JacksonJsonProvider(this.getObjectMapper());
            ClientBuilder builder = ClientBuilder.newBuilder();
            builder.register((Object)jacksonProvider);
            builder.register((Object)new ObjectMapperResolver());
            builder.register((Object)new LoggingFeature(Log, LoggingFeature.Verbosity.PAYLOAD_ANY));
            builder.property("jersey.config.client.followRedirects", (Object)this.isFollowRedirects());
            ISslContextProvider tmpProvider = this.getSslContextProvider() == null ? SslContextProvider.get() : this.getSslContextProvider();
            SSLContext sslContext = tmpProvider.createSslContext();
            builder.sslContext(sslContext);
            HostnameVerifier hostnameVerifier = tmpProvider.createHostnameVerifier();
            if (hostnameVerifier != null) {
                builder.hostnameVerifier(hostnameVerifier);
            }
            if (this.getConnectTimeout() >= 0L) {
                builder.connectTimeout(this.getConnectTimeout(), TimeUnit.MILLISECONDS);
            }
            if (this.getReadTimeout() >= 0L) {
                builder.readTimeout(this.getReadTimeout(), TimeUnit.MILLISECONDS);
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new WebhookConfigurationException(e);
        }
    }

    protected ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return mapper;
    }

    protected Map<String, Object> createParams(Map map) {
        return MapTools.flatten((Map)map);
    }

    protected WebTarget createTarget() throws WebhookException {
        return this.getClient().target(this.getEndpointUrl());
    }

    protected WebTarget createTargetGET() throws WebhookException {
        return this.getTarget();
    }

    protected WebTarget createTargetPOST() throws WebhookException {
        return this.getTarget();
    }

    protected <REQ, RES> RES doGet(Map<String, String> headers, Map<String, Object> params, Class<RES> responseType) throws WebhookException {
        WebTarget tempTarget = this.createTargetGET();
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                Object object = entry.getValue();
                if (object == null) continue;
                tempTarget = tempTarget.queryParam((String)entry.getKey(), new Object[]{"{var}"}).resolveTemplate("var", object);
            }
        }
        Invocation.Builder builder = tempTarget.request(new MediaType[]{MediaType.WILDCARD_TYPE});
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                builder = builder.header((String)entry.getKey(), entry.getValue());
            }
        }
        if (this.getAuthenticator() != null) {
            this.getAuthenticator().process(builder);
        }
        Invocation invocation = builder.buildGet();
        return this.invoke(invocation, responseType);
    }

    protected <REQ, RES> RES doPostEntity(Map<String, String> headers, Entity<REQ> entity, Class<RES> responseType) throws WebhookException {
        WebTarget tempTarget = this.createTargetPOST();
        Invocation.Builder builder = tempTarget.request(new MediaType[]{MediaType.WILDCARD_TYPE});
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                builder = builder.header(entry.getKey(), (Object)entry.getValue());
            }
        }
        if (this.getAuthenticator() != null) {
            this.getAuthenticator().process(builder);
        }
        Invocation invocation = builder.buildPost(entity);
        return this.invoke(invocation, responseType);
    }

    @Override
    public Object execute(Object payload) throws WebhookException {
        try {
            Log.debug("webhook {} send {}", (Object)this.id, payload);
            if ("GET".equals(this.getMethod())) {
                Map map = (Map)this.getObjectMapper().convertValue(payload, Map.class);
                Map<String, Object> params = this.createParams(map);
                Object result = this.doGet(null, params, Object.class);
                return result;
            }
            if ("POST".equals(this.getMethod())) {
                Entity entity = Entity.json((Object)payload);
                Object result = this.doPostEntity(null, entity, Object.class);
                return result;
            }
            throw new WebhookConfigurationException("invalid method " + this.getMethod());
        }
        catch (Exception e) {
            if (this.isSwallowExceptions()) {
                Log.warn("webhook {} call to {} failed", new Object[]{this.getId(), this.getEndpointUrl(), e});
                return null;
            }
            throw (WebhookExecutionException)ExceptionTools.createTyped((Throwable)e, WebhookExecutionException.class);
        }
    }

    public IWebhookAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public synchronized Client getClient() throws WebhookException {
        if (this.client == null) {
            this.client = this.createClient();
        }
        return this.client;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public WebhookException getException() {
        return this.exception;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getMethod() {
        return this.method;
    }

    public synchronized ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = this.createObjectMapper();
        }
        return this.objectMapper;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public Secret getSecret() {
        return this.secret;
    }

    public ISslContextProvider getSslContextProvider() {
        return this.sslContextProvider;
    }

    protected synchronized WebTarget getTarget() throws WebhookException {
        if (this.target == null) {
            this.target = this.createTarget();
        }
        return this.target;
    }

    protected <RES> RES handleResponse(Response response, Class<RES> responseType) {
        try {
            if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                Object object = response.readEntity(responseType);
                return (RES)object;
            }
            throw new WebApplicationException(response);
        }
        finally {
            response.close();
        }
    }

    @PostConstruct
    public void install() {
        if (!StringTools.isEmpty((String)this.getId())) {
            WebhookRegistry.get().registerStub(this);
        }
    }

    protected <RES> RES invoke(Invocation invocation, Class<RES> responseType) throws WebhookException {
        try {
            if (this.isAsync()) {
                invocation.submit();
                return null;
            }
            Response response = invocation.invoke();
            return this.handleResponse(response, responseType);
        }
        catch (Exception e) {
            throw new WebhookExecutionException(e);
        }
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public boolean isSwallowExceptions() {
        return this.swallowExceptions;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setAuthenticator(IWebhookAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setEndpointUrl(String endpoint) {
        this.endpointUrl = endpoint;
    }

    protected void setException(WebhookException exception) {
        this.exception = exception;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public synchronized void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setSecret(Secret secret) {
        this.secret = secret;
    }

    public void setSslContextProvider(ISslContextProvider sslContextProvider) {
        this.sslContextProvider = sslContextProvider;
    }

    public void setSwallowExceptions(boolean propagateError) {
        this.swallowExceptions = propagateError;
    }

    public class ObjectMapperResolver
    implements ContextResolver<ObjectMapper> {
        public ObjectMapper getContext(Class<?> type) {
            return StandardWebhookStub.this.getObjectMapper();
        }
    }
}

