/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.webhook.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.valueholder.INamedValue;
import de.intarsys.tools.webhook.api.IWebhookStub;
import de.intarsys.tools.webhook.api.WebhookRegistry;
import java.util.HashMap;

public class WebhookAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private Object webhook;
    private boolean swallowExceptions = true;

    protected void append(ILoggingEvent event) {
        block2: {
            Object payload = this.createPayload(event);
            IWebhookStub stub = this.createStub();
            try {
                stub.execute(payload);
            }
            catch (Exception e) {
                if (this.isSwallowExceptions()) break block2;
                throw ExceptionTools.wrap((Throwable)e);
            }
        }
    }

    protected Object createPayload(ILoggingEvent event) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Object object : event.getArgumentArray()) {
            if (!(object instanceof INamedValue)) continue;
            String name = ((INamedValue)object).getName();
            Object value = ((INamedValue)object).get();
            result.put(name, value);
        }
        return result;
    }

    protected IWebhookStub createStub() {
        IWebhookStub stub = null;
        if (this.getWebhook() instanceof String) {
            stub = WebhookRegistry.get().lookupStub((String)this.getWebhook());
        }
        if (this.getWebhook() instanceof IWebhookStub) {
            stub = (IWebhookStub)this.getWebhook();
        }
        if (stub == null) {
            throw new IllegalArgumentException("web hook '" + this.getWebhook() + "' not available");
        }
        return stub;
    }

    public Object getWebhook() {
        return this.webhook;
    }

    public boolean isSwallowExceptions() {
        return this.swallowExceptions;
    }

    public void setSwallowExceptions(boolean swallowExceptions) {
        this.swallowExceptions = swallowExceptions;
    }

    public void setWebhook(Object webhook) {
        this.webhook = webhook;
    }
}

