/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.widget.common;

import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.message.MessageTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.widget.model.ActionSpec;
import java.util.List;
import java.util.Map;

public class ActionExpander {
    private IStringEvaluator evaluator;

    public static void process(ActionSpec action) {
        new ActionExpander().expand(action);
    }

    public static void process(IStringEvaluator evaluator, ActionSpec action) {
        new ActionExpander(evaluator).expand(action);
    }

    public static void process(IStringEvaluator evaluator, List<ActionSpec> actions) {
        actions.stream().forEach(action -> ActionExpander.process(evaluator, action));
    }

    public static void process(List<ActionSpec> actions) {
        actions.stream().forEach(action -> ActionExpander.process(action));
    }

    public ActionExpander() {
        this.evaluator = TemplateEvaluator.get((Mode)Mode.UNTRUSTED);
    }

    public ActionExpander(IStringEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void expand(ActionSpec action) {
        String ref = action.getRef();
        if (!StringTools.isEmpty((String)ref)) {
            action.setRef(String.valueOf(MessageTools.toObjectExpanded((IStringEvaluator)this.getEvaluator(), (Object)ref)));
        }
        Map newArgs = (Map)LangTools.applyDeep(action.getArgs(), binding -> this.expandObject(binding.getValue()));
        action.setArgs(newArgs);
    }

    protected Object expandObject(Object value) {
        Object expanded = MessageTools.toObjectExpanded((IStringEvaluator)this.getEvaluator(), (Object)value);
        if (expanded instanceof ActionSpec) {
            this.expand((ActionSpec)expanded);
            return expanded;
        }
        return LangTools.copyDeep((Object)expanded);
    }

    public IStringEvaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(IStringEvaluator evaluator) {
        this.evaluator = evaluator;
    }
}

