/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.widget.common;

import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.ui.toolkit.Toolkit;
import de.intarsys.widget.model.IWidgetDefinition;
import de.intarsys.widget.model.IWidgetItem;
import de.intarsys.widget.model.IWidgetItemFactory;
import de.intarsys.widget.model.IWidgetItemVisitor;
import de.intarsys.widget.model.WidgetItem;
import de.intarsys.widget.model.WidgetItemOutlet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonWidgetItemFactory
implements IWidgetItemFactory {
    private static final Attribute ATTR_CUSTOMIZER = new Attribute("customizer");
    private static final Logger Log = LoggerFactory.getLogger(CommonWidgetItemFactory.class);
    private boolean separatorRequested = false;

    protected static IWidgetItemVisitor getCustomizer(WidgetItem widgetItem) {
        return (IWidgetItemVisitor)widgetItem.getAttribute(ATTR_CUSTOMIZER);
    }

    protected static Object getImpl(IWidgetItem widgetItem) {
        IWidgetItem tempCurrent = widgetItem;
        Object impl = tempCurrent.getImpl();
        while (impl == null) {
            if ((tempCurrent = tempCurrent.getParent()) == null) {
                return null;
            }
            impl = tempCurrent.getImpl();
        }
        return impl;
    }

    protected static void setCustomizer(WidgetItem widgetItem, IWidgetItemVisitor customizer) {
        widgetItem.setAttribute(ATTR_CUSTOMIZER, customizer);
    }

    protected void arm(IWidgetItem widgetItem) {
    }

    protected abstract Object basicCreateImpl(WidgetItem var1, Object var2);

    protected WidgetItem basicCreateWidgetItem(IWidgetItem parentItem, IWidgetDefinition definition) {
        return new WidgetItem(this, definition, parentItem);
    }

    protected void basicCreateWidgetItemChildren(IWidgetItem widgetItem, List<IWidgetDefinition> children, Object parentImpl, IWidgetItemVisitor customizer) {
        for (IWidgetDefinition child : children) {
            String type = child.getType();
            IWidgetItemFactory factory = StringTools.isEmpty((String)type) ? widgetItem.getFactory() : WidgetItemOutlet.get().lookupWidgetItemFactory(type);
            if (factory == null) continue;
            factory.createWidgetItem(widgetItem, parentImpl, child, customizer);
        }
    }

    protected abstract void basicDisposeImpl(WidgetItem var1);

    protected Object createImpl(WidgetItem widgetItem, Object parentImpl) {
        Object impl = widgetItem.getImpl();
        if (impl == null) {
            impl = this.basicCreateImpl(widgetItem, parentImpl);
            widgetItem.setImpl(impl);
            this.setWidgetItem(impl, widgetItem);
        }
        return impl;
    }

    protected WidgetItem createWidgetItem(IWidgetItem parentItem, IWidgetDefinition definition, IWidgetItemVisitor customizer) {
        WidgetItem widgetItem = null;
        if (definition.getId() != null && parentItem != null) {
            widgetItem = (WidgetItem)parentItem.getWidgetItem(definition.getId());
        }
        if (widgetItem == null) {
            widgetItem = this.basicCreateWidgetItem(parentItem, definition);
            if (customizer != null) {
                widgetItem.accept(customizer);
                CommonWidgetItemFactory.setCustomizer(widgetItem, customizer);
            }
        }
        return widgetItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IWidgetItem createWidgetItem(IWidgetItem parentItem, Object parentImpl, IWidgetDefinition definition, IWidgetItemVisitor customizer) {
        WidgetItem widgetItem = this.createWidgetItem(parentItem, definition, customizer);
        try {
            Object visible = widgetItem.getValue("visible");
            if (Boolean.FALSE.equals(visible)) {
                return null;
            }
        }
        catch (Exception e) {
            Log.warn("error evaluating 'visible' for " + widgetItem, (Throwable)e);
            return null;
        }
        boolean tempSeparatorRequested = definition.isStyle("separator");
        try {
            this.setSeparatorRequested(tempSeparatorRequested || this.isSeparatorRequested());
            widgetItem.disableUpdatePropagation();
            Object impl = this.createImpl(widgetItem, parentImpl);
            this.createWidgetItemChildren(widgetItem, definition, impl == null ? parentImpl : impl, customizer);
            this.setSeparatorRequested(tempSeparatorRequested || this.isSeparatorRequested());
            widgetItem.enableUpdatePropagation();
        }
        catch (Throwable throwable) {
            this.setSeparatorRequested(tempSeparatorRequested || this.isSeparatorRequested());
            widgetItem.enableUpdatePropagation();
            throw throwable;
        }
        this.arm(widgetItem);
        return widgetItem;
    }

    protected void createWidgetItemChildren(IWidgetItem widgetItem, IWidgetDefinition widgetDefinition, Object parentImpl, IWidgetItemVisitor customizer) {
        List<IWidgetDefinition> children = widgetDefinition.getWidgetDefinitions();
        if (children.isEmpty()) {
            return;
        }
        this.basicCreateWidgetItemChildren(widgetItem, children, parentImpl, customizer);
    }

    protected void disarm(IWidgetItem widgetItem) {
    }

    public void fromWidgetItemDispose(WidgetItem widgetItem) {
        this.disarm(widgetItem);
        this.basicDisposeImpl(widgetItem);
    }

    public final void fromWidgetItemTriggerChange(final WidgetItem widgetItem, final AttributeChangedEvent event) {
        Toolkit.get().invokeNow(new Runnable(){

            @Override
            public void run() {
                CommonWidgetItemFactory.this.guiFromWidgetItemTriggerChange(widgetItem, event);
            }
        });
    }

    protected abstract WidgetItem getWidgetItem(Object var1);

    protected void guiFromWidgetItemTriggerChange(WidgetItem widgetItem, AttributeChangedEvent event) {
        if ("visible".equals(event.getAttribute())) {
            if (widgetItem.isVisible()) {
                this.showWidget(widgetItem);
            } else {
                this.hideWidget(widgetItem);
            }
        } else if (widgetItem.isVisible()) {
            this.updateImpl(widgetItem, event);
        }
    }

    protected void hideWidget(WidgetItem widgetItem) {
    }

    protected boolean isAttributeChanged(AttributeChangedEvent event, Object attribute) {
        return event == null || event.getAttribute() == null || event.getAttribute().equals(attribute);
    }

    protected boolean isSeparatorRequested() {
        return this.separatorRequested;
    }

    protected void setSeparatorRequested(boolean value) {
        this.separatorRequested = value;
    }

    protected abstract void setWidgetItem(Object var1, WidgetItem var2);

    protected void showWidget(WidgetItem widgetItem) {
    }

    protected void updateImpl(WidgetItem widgetItem, AttributeChangedEvent event) {
    }
}

