/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.widget.common;

import de.intarsys.tools.action.IAction;
import de.intarsys.tools.action.IActionRegistry;
import de.intarsys.widget.model.IWidgetDefinition;
import de.intarsys.widget.model.IWidgetDefinitionContainer;
import de.intarsys.widget.model.WidgetDefinition;

public class WidgetDefinitionBuilder {
    private final IActionRegistry actionRegistry;
    private IWidgetDefinition currentParent;
    private final IWidgetDefinitionContainer root;

    public WidgetDefinitionBuilder(IActionRegistry actionRegistry, IWidgetDefinitionContainer root) {
        this.actionRegistry = actionRegistry;
        this.root = root;
        this.currentParent = null;
    }

    public WidgetDefinition createDynamic(Object value) {
        WidgetDefinition definition = new WidgetDefinition(this.getCurrentParent(), null, "dynamic");
        definition.setValue("children", value);
        return definition;
    }

    public WidgetDefinition createShortcut(String id, String shortcut) {
        IAction action = this.actionRegistry.lookupAction(id);
        if (action == null) {
            return null;
        }
        WidgetDefinition definition = WidgetDefinition.create(this.getCurrentParent(), action);
        definition.setValue("shortcut", shortcut);
        return definition;
    }

    public WidgetDefinition createTrigger(String id) {
        IAction action = this.actionRegistry.lookupAction(id);
        if (action == null) {
            return null;
        }
        WidgetDefinition definition = WidgetDefinition.create(this.getCurrentParent(), action);
        return definition;
    }

    public IWidgetDefinitionContainer endGroup() {
        this.currentParent = this.currentParent.getParent();
        return this.getCurrentParent();
    }

    protected IActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public IWidgetDefinition getCurrentParent() {
        return this.currentParent;
    }

    public IWidgetDefinitionContainer getRoot() {
        return this.root;
    }

    public IWidgetDefinition select(String path) {
        this.currentParent = this.root.getWidgetDefinition(path);
        return this.getCurrentParent();
    }

    public WidgetDefinition startGroup(String id, String style) {
        return this.startGroup(id, style, null);
    }

    public WidgetDefinition startGroup(String id, String style, String type) {
        WidgetDefinition group = null;
        if (id != null) {
            group = (WidgetDefinition)this.getCurrentParent().getWidgetDefinition(id);
        }
        if (group == null) {
            group = new WidgetDefinition(this.getCurrentParent(), id);
            group.setComposite(true);
            group.setType(type);
            if (style != null) {
                group.addStyle(style);
            }
        }
        this.currentParent = group;
        return group;
    }
}

