/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.widget.common;

import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.StringEvaluatorTools;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.message.MessageTools;
import de.intarsys.tools.reflect.IMethodHandler;
import de.intarsys.widget.common.ActionExpander;
import de.intarsys.widget.model.ActionSpec;
import de.intarsys.widget.model.IconDefinition;
import de.intarsys.widget.model.StyledTextDefinition;
import de.intarsys.widget.model.WidgetDefinition;
import java.util.List;

public class WidgetExpander {
    private IStringEvaluator evaluator;

    public static void process(IStringEvaluator evaluator, List<WidgetDefinition> widgets) {
        widgets.stream().forEach(widget -> WidgetExpander.process(evaluator, widget));
    }

    public static void process(IStringEvaluator evaluator, WidgetDefinition widget) {
        new WidgetExpander(evaluator).expand(widget);
    }

    public static void process(List<WidgetDefinition> widgets) {
        widgets.stream().forEach(widget -> WidgetExpander.process(widget));
    }

    public static void process(WidgetDefinition widget) {
        new WidgetExpander().expand(widget);
    }

    public WidgetExpander() {
        this.evaluator = TemplateEvaluator.get((Mode)Mode.UNTRUSTED);
    }

    public WidgetExpander(IStringEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    protected void expand(IMethodHandler callback) {
        if (callback instanceof ActionSpec) {
            ActionExpander.process(this.getEvaluator(), (ActionSpec)callback);
        }
    }

    public void expand(WidgetDefinition widget) {
        StyledTextDefinition label;
        IconDefinition icon = widget.getIcon();
        if (icon != null) {
            icon.setDescriptor(StringEvaluatorTools.evaluateString((IStringEvaluator)this.getEvaluator(), (String)icon.getDescriptor()));
        }
        if ((label = widget.getLabelDefinition()) != null) {
            label.setMessageString(MessageTools.toSafeStringExpanded((IStringEvaluator)this.getEvaluator(), (Object)label.getMessage()));
        }
        widget.setTip(MessageTools.toStringExpanded((IStringEvaluator)this.getEvaluator(), (Object)widget.getTipRaw()));
        widget.setDescription(MessageTools.toStringExpanded((IStringEvaluator)this.getEvaluator(), (Object)widget.getDescriptionRaw()));
        LangTools.applyDeep(widget.getProperties(), binding -> this.expandObject(binding.getValue()));
        if (widget.getChildren() != null) {
            widget.getChildren().forEach(child -> this.expand((WidgetDefinition)child));
        }
        if (widget.getCallbacks() != null) {
            widget.getCallbacks().values().forEach(callback -> this.expand((IMethodHandler)callback));
        }
    }

    protected Object expandObject(Object value) {
        Object expanded = MessageTools.toObjectExpanded((IStringEvaluator)this.getEvaluator(), (Object)value);
        return LangTools.copyDeep((Object)expanded);
    }

    public IStringEvaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(IStringEvaluator evaluator) {
        this.evaluator = evaluator;
    }
}

