/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.widget.common;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.event.wrapper.RequestEvent;
import de.intarsys.tools.facade.FacadeTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import de.intarsys.widget.common.CommonWidgetDefinitionVisitor;
import de.intarsys.widget.model.IWidgetDefinition;
import de.intarsys.widget.model.IWidgetDefinitionContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetScript
extends CommonWidgetDefinitionVisitor
implements IElementConfigurable,
IContextSupport {
    private static final Logger Log = LoggerFactory.getLogger(WidgetScript.class);
    private IFunctor condition;
    private List deactivate = new ArrayList();
    private Object context;

    @Override
    protected void basicVisitBefore(IWidgetDefinition definition) {
        if (!this.evaluateCondition()) {
            return;
        }
        for (String path : this.deactivate) {
            this.deactivateWidget(path, definition);
        }
    }

    @Override
    protected void basicVisitChildren(IWidgetDefinition definition) {
    }

    public void configure(IElement element) throws ConfigurationException {
        try {
            IElement conditionElement = element.element("condition");
            IFunctor tempFunctor = ElementTools.createFunctor((Object)this.getContext(), (IElement)conditionElement, null, (Object)this.getContext());
            this.setCondition(tempFunctor);
        }
        catch (ObjectCreationException e) {
            Log.warn("error creating codeexit", (Throwable)e);
            return;
        }
        IElement eCommands = element.element("commands");
        if (eCommands == null) {
            Log.warn("element 'commands' missing");
            eCommands = element;
        }
        this.readCommands(eCommands);
    }

    protected void deactivateWidget(String path, IWidgetDefinitionContainer registry) {
        IWidgetDefinition widget = registry.getWidgetDefinition(path);
        if (widget == null) {
            Log.warn("WidgetDeactivator: widget path '" + path + "' not found");
            return;
        }
        widget.dispose();
    }

    protected boolean evaluateCondition() {
        if (this.getCondition() == null) {
            return true;
        }
        RequestEvent event = new RequestEvent((Object)this);
        Args args = Args.create();
        args.put("event", FacadeTools.createFacade((Object)event));
        args.put("jevent", (Object)event);
        args.put("jEvent", (Object)event);
        try {
            return (Boolean)this.getCondition().perform((IFunctorCall)new FunctorCall(null, (IArgs)args));
        }
        catch (FunctorException e) {
            Log.warn("error evaluating condition", (Throwable)e);
            return false;
        }
    }

    public IFunctor getCondition() {
        return this.condition;
    }

    public Object getContext() {
        return this.context;
    }

    protected void readCommands(IElement element) {
        Iterator nDeactivateList = element.elementIterator("deactivate");
        while (nDeactivateList.hasNext()) {
            IElement nDeactivate = (IElement)nDeactivateList.next();
            String pathValue = nDeactivate.attributeValue("path", null);
            if (StringTools.isEmpty((String)pathValue)) continue;
            this.deactivate.add(pathValue);
        }
    }

    public void setCondition(IFunctor condition) {
        this.condition = condition;
    }

    public void setContext(Object context) {
        this.context = context;
    }
}

