/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.widget.common;

import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.widget.model.ActionSpec;
import de.intarsys.widget.model.ICallbackSupport;
import de.intarsys.widget.model.IWidgetDefinition;
import de.intarsys.widget.model.IWidgetItem;
import de.intarsys.widget.model.IWidgetItemFactory;
import de.intarsys.widget.model.IWidgetItemVisitor;
import de.intarsys.widget.model.WidgetItem;
import de.intarsys.widget.model.WidgetItemOutlet;

public class WidgetTools {
    public static final String ARG_CONTEXT = "context";
    public static final String ARG_TARGET = "target";

    public static IWidgetItem build(IWidgetItem parentItem, Object parentImpl, IWidgetDefinition definition, IWidgetItemVisitor customizer) {
        if (definition == null) {
            return null;
        }
        String type = definition.getType();
        IWidgetItemFactory factory = WidgetItemOutlet.get().lookupWidgetItemFactory(type);
        if (factory == null) {
            return null;
        }
        return factory.createWidgetItem(parentItem, parentImpl, definition, customizer);
    }

    public static IWidgetItem createContainer() {
        return new WidgetItem(null, null, null);
    }

    public static void defineCallbacks(ICallbackSupport target, IArgs definition) {
        ActionSpec actionSpec;
        for (IArgs.IBinding binding : definition) {
            String propertyName = binding.getName();
            Object propertyValue = binding.getValue();
            if (!propertyName.startsWith("on-") || propertyName.length() <= 3) continue;
            String callbackName = propertyName.substring(3);
            actionSpec = ActionSpec.build(propertyValue);
            target.setCallback(callbackName, actionSpec);
        }
        IArgs callbacks = ArgTools.getArgs((IArgs)definition, (String)"callbacks", null);
        if (callbacks != null) {
            for (IArgs.IBinding binding : callbacks) {
                String callbackName = binding.getName();
                Object propertyValue = binding.getValue();
                actionSpec = ActionSpec.build(propertyValue);
                target.setCallback(callbackName, actionSpec);
            }
        }
    }

    public static Object getContext(IFunctorCall call) {
        IAttributeSupport receiver = (IAttributeSupport)call.getReceiver();
        return receiver.getAttribute((Object)ARG_CONTEXT);
    }

    public static Object getTarget(IFunctorCall call) {
        IAttributeSupport receiver = (IAttributeSupport)call.getReceiver();
        return receiver.getAttribute((Object)ARG_TARGET);
    }

    private WidgetTools() {
    }
}

