/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.widget.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.jackson.JsonElementAdapter;
import de.intarsys.widget.json.CommonWidgetDeserializer;
import de.intarsys.widget.json.WidgetModule;
import de.intarsys.widget.model.ActionSpec;
import de.intarsys.widget.model.StandardWidgetDefinitionFactory;
import de.intarsys.widget.model.WidgetDefinition;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WidgetDefinitionDeserializer
extends CommonWidgetDeserializer<WidgetDefinition> {
    public WidgetDefinitionDeserializer(WidgetModule module) {
        super(module, WidgetDefinition.class);
    }

    public WidgetDefinition deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        try {
            WidgetDefinition result = new WidgetDefinition();
            result.setFactory(new StandardWidgetDefinitionFactory());
            result.configure((IElement)new JsonElementAdapter((ContainerNode)((ObjectNode)node)));
            JsonNode nodeCallbacks = node.with("callbacks");
            result.setCallbacks(this.deserializeCallbacks(jp, ctxt, (ObjectNode)nodeCallbacks));
            Iterator itFields = node.fields();
            while (itFields.hasNext()) {
                Map.Entry field = (Map.Entry)itFields.next();
                String key = (String)field.getKey();
                String callbackName = null;
                if (key.startsWith("on-")) {
                    callbackName = key.substring(3);
                }
                if (callbackName == null) continue;
                JsonNode actionNode = (JsonNode)field.getValue();
                Object action = jp.getCodec().treeToValue((TreeNode)actionNode, ActionSpec.class);
                result.setCallback(callbackName, action);
            }
            JsonNode nodeProperties = node.with("properties");
            result.setProperties(this.deserializeProperties(jp, ctxt, (ObjectNode)nodeProperties));
            return result;
        }
        catch (Exception e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof JsonProcessingException) {
                JsonProcessingException jpe = (JsonProcessingException)throwable;
                throw jpe;
            }
            throw new JsonMappingException((Closeable)jp, "cannot create WidgetDefinition", (Throwable)e);
        }
    }

    protected Map<String, Object> deserializeCallbacks(JsonParser jp, DeserializationContext ctxt, ObjectNode node) throws JsonProcessingException {
        HashMap<String, Object> callbacks = new HashMap<String, Object>();
        Iterator itFields = node.fields();
        while (itFields.hasNext()) {
            Map.Entry field = (Map.Entry)itFields.next();
            String callback = (String)field.getKey();
            JsonNode actionNode = (JsonNode)field.getValue();
            Object action = jp.getCodec().treeToValue((TreeNode)actionNode, ActionSpec.class);
            callbacks.put(callback, action);
        }
        return callbacks;
    }

    protected Map<String, Object> deserializeProperties(JsonParser jp, DeserializationContext ctxt, ObjectNode node) throws JsonProcessingException {
        return (Map)jp.getCodec().treeToValue((TreeNode)node, Map.class);
    }
}

