/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.widget.model;

import de.intarsys.tools.collection.MapTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ArgsElementAdapter;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.infoset.INode;
import de.intarsys.tools.lang.ICopyDeep;
import de.intarsys.tools.reflect.IMethodHandler;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ActionSpec
implements IMethodHandler,
ICopyDeep,
IElementSerializable {
    public static final String COMMAND_BLOCK = "Block";
    public static final String COMMAND_OK = "Ok";
    public static final String BLOCK_ACTION = "action";
    public static final String BLOCK_FINALLY = "finally";
    public static final String BLOCK_CATCH = "catch";
    public static final String BLOCK_TRY = "try";
    public static final String DEFINITION_ARGS = "args";
    public static final String DEFINITION_FACTORY = "factory";
    public static final String DEFINITION_REF = "ref";
    public static final String DEFINITION_ID = "id";
    public static final String DEFINITION_TYPE = "type";
    private String factory;
    private String ref;
    private Map<String, Object> args;
    private SerializationStyle style = SerializationStyle.instanceSpec;

    public static ActionSpec block() {
        ActionSpec block = new ActionSpec();
        block.setFactory(COMMAND_BLOCK);
        HashMap<String, Object> args = new HashMap<String, Object>();
        block.setArgs(args);
        return block;
    }

    public static ActionSpec blockTry(Object tryActions) {
        ActionSpec block = new ActionSpec();
        block.setFactory(COMMAND_BLOCK);
        HashMap<String, Object> args = new HashMap<String, Object>();
        block.setArgs(args);
        args.put(BLOCK_TRY, ActionSpec.buildNested(tryActions));
        return block;
    }

    public static ActionSpec blockTryCatchFinally(Map args, Object tryActions, Object catchActions, Object finallyActions) {
        ActionSpec block = new ActionSpec();
        block.setFactory(COMMAND_BLOCK);
        block.setArgs(args);
        args.put(BLOCK_TRY, ActionSpec.buildNested(tryActions));
        args.put(BLOCK_CATCH, ActionSpec.buildNested(catchActions));
        args.put(BLOCK_FINALLY, ActionSpec.buildNested(finallyActions));
        return block;
    }

    public static ActionSpec build(IArgs definition) {
        String ref = (String)definition.get(DEFINITION_REF);
        if (!StringTools.isEmpty((String)ref)) {
            return new Builder().ref(ref).build();
        }
        String factory = (String)definition.get(DEFINITION_FACTORY);
        if (!StringTools.isEmpty((String)factory)) {
            String id = (String)definition.get(DEFINITION_ID);
            if (!StringTools.isEmpty((String)id)) {
                throw new IllegalArgumentException("'id' must be defined in 'args' when using 'factory'");
            }
            Map args = ArgTools.getMap((IArgs)definition, (String)DEFINITION_ARGS, null);
            return new Builder().styleInstanceSpec().factory(factory).args(args).build();
        }
        String type = (String)definition.get(DEFINITION_TYPE);
        if (!StringTools.isEmpty((String)type)) {
            return new Builder().styleTyped().factory(type).args(ArgTools.toMap((IArgs)definition)).build();
        }
        Object tryActions = definition.get(BLOCK_TRY);
        Object catchActions = definition.get(BLOCK_CATCH);
        Object finallyActions = definition.get(BLOCK_FINALLY);
        if (tryActions == null) {
            throw new IllegalArgumentException("'ref', 'factory', 'type' or 'try' expected in '" + definition + "'");
        }
        Map blockArgs = ArgTools.toMap((IArgs)definition);
        blockArgs.remove(BLOCK_TRY);
        blockArgs.remove(BLOCK_CATCH);
        blockArgs.remove(BLOCK_FINALLY);
        return ActionSpec.blockTryCatchFinally(blockArgs, tryActions, catchActions, finallyActions);
    }

    public static ActionSpec build(IElement definition) {
        if (definition.isIndexed()) {
            return ActionSpec.buildIndexed(definition);
        }
        return ActionSpec.buildNamed(definition);
    }

    public static ActionSpec build(List definition) {
        return ActionSpec.blockTry(definition);
    }

    public static ActionSpec build(Map<String, Object> definition) {
        String ref = (String)definition.get(DEFINITION_REF);
        if (!StringTools.isEmpty((String)ref)) {
            return new Builder().ref(ref).build();
        }
        String factory = (String)definition.get(DEFINITION_FACTORY);
        if (!StringTools.isEmpty((String)factory)) {
            Map args = (Map)definition.get(DEFINITION_ARGS);
            return new Builder().styleInstanceSpec().factory(factory).args(args).build();
        }
        String type = (String)definition.get(DEFINITION_TYPE);
        if (!StringTools.isEmpty((String)type)) {
            return new Builder().styleTyped().factory(type).args(definition).build();
        }
        Object tryActions = definition.get(BLOCK_TRY);
        Object catchActions = definition.get(BLOCK_CATCH);
        Object finallyActions = definition.get(BLOCK_FINALLY);
        HashMap<String, Object> blockArgs = new HashMap<String, Object>(definition);
        blockArgs.remove(BLOCK_TRY);
        blockArgs.remove(BLOCK_CATCH);
        blockArgs.remove(BLOCK_FINALLY);
        return ActionSpec.blockTryCatchFinally(blockArgs, tryActions, catchActions, finallyActions);
    }

    public static ActionSpec build(Object definition) {
        if (definition == null) {
            return null;
        }
        if (definition instanceof List) {
            return ActionSpec.build((List)definition);
        }
        if (definition instanceof String) {
            return ActionSpec.build((String)definition);
        }
        if (definition instanceof IElement) {
            return ActionSpec.build((IElement)definition);
        }
        if (definition instanceof IArgs) {
            return ActionSpec.build((IArgs)definition);
        }
        if (definition instanceof Map) {
            return ActionSpec.build((Map)definition);
        }
        if (definition instanceof ActionSpec) {
            return (ActionSpec)definition;
        }
        throw new IllegalArgumentException("array or object expected, not '" + definition + "'");
    }

    public static ActionSpec build(String ref) {
        return new Builder().ref(ref).build();
    }

    public static ActionSpec build(String factory, Map<String, Object> args) {
        return new Builder().factory(factory).args(args).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static ActionSpec buildIndexed(IElement definition) {
        ArrayList<ActionSpec> result = new ArrayList<ActionSpec>();
        Iterator it = definition.elementIterator();
        while (it.hasNext()) {
            result.add(ActionSpec.build((IElement)it.next()));
        }
        return ActionSpec.blockTry(result);
    }

    private static ActionSpec buildNamed(IElement definition) {
        String ref = definition.attributeValue(DEFINITION_REF, null);
        if (!StringTools.isEmpty((String)ref)) {
            return new Builder().ref(ref).build();
        }
        String factory = definition.attributeValue(DEFINITION_FACTORY, null);
        if (!StringTools.isEmpty((String)factory)) {
            String id = definition.attributeValue(DEFINITION_ID, null);
            if (!StringTools.isEmpty((String)id)) {
                throw new IllegalArgumentException("'id' must be defined in 'args' when using 'factory'");
            }
            Map args = (Map)ElementTools.toJavaDeep((INode)definition.element(DEFINITION_ARGS));
            return new Builder().styleInstanceSpec().factory(factory).args(args).build();
        }
        String type = definition.attributeValue(DEFINITION_TYPE, null);
        Map args = (Map)ElementTools.toJavaDeep((INode)definition);
        if (!StringTools.isEmpty((String)type)) {
            return new Builder().styleTyped().factory(type).args(args).build();
        }
        Object tryActions = args.get(BLOCK_TRY);
        Object catchActions = args.get(BLOCK_CATCH);
        Object finallyActions = args.get(BLOCK_FINALLY);
        if (tryActions == null) {
            throw new IllegalArgumentException("'ref', 'factory', 'type' or 'try' expected in '" + definition + "'");
        }
        args.remove(BLOCK_TRY);
        args.remove(BLOCK_CATCH);
        args.remove(BLOCK_FINALLY);
        return ActionSpec.blockTryCatchFinally(args, tryActions, catchActions, finallyActions);
    }

    protected static List<ActionSpec> buildNested(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return null;
            }
            ArrayList<ActionSpec> result = new ArrayList<ActionSpec>();
            for (Object element : list) {
                result.add(ActionSpec.build(element));
            }
            return result;
        }
        ArrayList<ActionSpec> result = new ArrayList<ActionSpec>();
        result.add(ActionSpec.build(object));
        return result;
    }

    public ActionSpec copyDeep() {
        ActionSpec result = new ActionSpec();
        result.args = MapTools.copyDeep(this.args);
        result.factory = this.factory;
        result.ref = this.ref;
        result.style = this.style;
        return result;
    }

    public Map<String, Object> getArgs() {
        if (this.args == null) {
            return Collections.emptyMap();
        }
        return this.args;
    }

    public List<ActionSpec> getBlockCatch() {
        return ActionSpec.buildNested(this.args.get(BLOCK_CATCH));
    }

    public List<ActionSpec> getBlockFinally() {
        return ActionSpec.buildNested(this.args.get(BLOCK_FINALLY));
    }

    public List<ActionSpec> getBlockTry() {
        return ActionSpec.buildNested(this.args.get(BLOCK_TRY));
    }

    public String getFactory() {
        return this.factory;
    }

    public String getId() {
        if (this.args != null) {
            return (String)this.args.get(DEFINITION_ID);
        }
        return null;
    }

    public String getRef() {
        return this.ref;
    }

    public SerializationStyle getStyle() {
        return this.style;
    }

    public Object invoke(Object receiver, IArgs args) throws MethodException {
        throw new UnsupportedOperationException("this is client side behavior");
    }

    public void serialize(IElement element) throws ElementSerializationException {
        if (!StringTools.isEmpty((String)this.getRef())) {
            element.setAttributeValue(DEFINITION_REF, this.getRef());
        } else if (this.getStyle() == SerializationStyle.instanceSpec) {
            element.setAttributeValue(DEFINITION_FACTORY, this.getFactory());
            Map<String, Object> definitions = this.getArgs();
            if (definitions != null && !definitions.isEmpty()) {
                ElementTools.putObject((IElement)element, (String)DEFINITION_ARGS, (Object)ArgTools.toArgs(definitions));
            }
        } else {
            Map<String, Object> definitions = this.getArgs();
            element.setAttributeValue(DEFINITION_TYPE, this.getFactory());
            if (definitions != null && !definitions.isEmpty()) {
                ElementTools.copy((IElement)element, (IElement)new ArgsElementAdapter(ArgTools.toArgs(definitions)));
            }
        }
    }

    public void setArgs(Map<String, Object> args) {
        this.args = args;
    }

    public void setFactory(String type) {
        this.factory = type;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public void setStyle(SerializationStyle style) {
        this.style = style;
    }

    public static enum SerializationStyle {
        instanceSpec,
        typed;

    }

    public static class Builder {
        private BlockBuilder block;
        private ActionSpec action;

        public Builder() {
            this.action = new ActionSpec();
        }

        public Builder(BlockBuilder block) {
            this.block = block;
            this.action = new ActionSpec();
        }

        public Builder arg(String name, Object value) {
            this.ensureArgs();
            this.action.args.put(name, value);
            return this;
        }

        public Builder args(Map<String, Object> args) {
            this.action.setArgs(args);
            return this;
        }

        protected BlockBuilder block(String keyword) {
            this.factory(ActionSpec.COMMAND_BLOCK);
            this.ensureArgs();
            ArrayList<ActionSpec> actions = (ArrayList<ActionSpec>)this.action.args.get(keyword);
            if (actions == null) {
                actions = new ArrayList<ActionSpec>();
                this.arg(keyword, actions);
            }
            return new BlockBuilder(this, actions);
        }

        public BlockBuilder blockCatch() {
            return this.block(ActionSpec.BLOCK_CATCH);
        }

        public BlockBuilder blockFinally() {
            return this.block(ActionSpec.BLOCK_FINALLY);
        }

        public BlockBuilder blockTry() {
            return this.block(ActionSpec.BLOCK_TRY);
        }

        public ActionSpec build() {
            return this.action;
        }

        public BlockBuilder close() {
            this.block.add(this);
            return this.block;
        }

        protected void ensureArgs() {
            if (this.action.args == null) {
                this.action.setArgs(new LinkedHashMap<String, Object>());
            }
        }

        public Builder factory(String string) {
            this.action.setFactory(string);
            return this;
        }

        public Builder ref(String string) {
            this.action.setRef(string);
            return this;
        }

        public Builder styleInstanceSpec() {
            this.action.setStyle(SerializationStyle.instanceSpec);
            return this;
        }

        public Builder styleTyped() {
            this.action.setStyle(SerializationStyle.typed);
            return this;
        }
    }

    public static class BlockBuilder {
        private Builder parent;
        private List<ActionSpec> actions;

        public BlockBuilder(Builder parent, List<ActionSpec> actions) {
            this.parent = parent;
            this.actions = actions;
        }

        public Builder add() {
            return new Builder(this);
        }

        public void add(Builder builder) {
            this.actions.add(builder.build());
        }

        public Builder close() {
            return this.parent;
        }
    }
}

