/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.widget.model;

import de.intarsys.tools.lang.ICopyDeep;
import de.intarsys.widget.model.IWidgetDefinition;
import de.intarsys.widget.model.IWidgetDefinitionContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class CommonWidgetDefinitionContainer
implements IWidgetDefinitionContainer,
ICopyDeep {
    private List<IWidgetDefinition> children;

    @Override
    public void addWidgetDefinition(IWidgetDefinition child) {
        this.basicAddWidgetDefinition(child);
    }

    protected synchronized void basicAddWidgetDefinition(IWidgetDefinition child) {
        if (this.children == null) {
            this.setChildren(new ArrayList<IWidgetDefinition>());
        }
        this.children.add(child);
    }

    protected synchronized IWidgetDefinition basicGetWidgetDefinition(String childId) {
        if (this.children == null) {
            return null;
        }
        for (IWidgetDefinition child : this.children) {
            if (!this.matchesChild(child, childId)) continue;
            return child;
        }
        return null;
    }

    protected void copyDeep(CommonWidgetDefinitionContainer result) {
        if (this.children != null) {
            this.children.stream().map(child -> (IWidgetDefinition)((ICopyDeep)child).copyDeep()).forEach(copy -> result.addWidgetDefinition((IWidgetDefinition)copy));
        }
    }

    public List<IWidgetDefinition> getChildren() {
        return this.children;
    }

    @Override
    public IWidgetDefinition getWidgetDefinition(String path) {
        int pos = path.indexOf(47);
        if (pos > 0) {
            IWidgetDefinition childDefinition = this.basicGetWidgetDefinition(path.substring(0, pos));
            if (childDefinition != null) {
                return childDefinition.getWidgetDefinition(path.substring(pos + 1));
            }
            return null;
        }
        if (pos == 0) {
            return this.getWidgetDefinition(path.substring(1));
        }
        return this.basicGetWidgetDefinition(path);
    }

    @Override
    public List<IWidgetDefinition> getWidgetDefinitions() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return new ArrayList<IWidgetDefinition>(this.children);
    }

    public boolean isComposite() {
        return this.children != null;
    }

    public boolean isEmpty() {
        if (this.isItem()) {
            return false;
        }
        for (IWidgetDefinition child : this.children) {
            if (child.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isItem() {
        return this.children == null;
    }

    protected abstract boolean matchesChild(IWidgetDefinition var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWidgetDefinition(IWidgetDefinition child) {
        CommonWidgetDefinitionContainer commonWidgetDefinitionContainer = this;
        synchronized (commonWidgetDefinitionContainer) {
            if (this.children == null) {
                return;
            }
            this.children.remove(child);
        }
    }

    public void setChildren(List<IWidgetDefinition> children) {
        this.children = children;
    }

    public void setComposite(boolean composite) {
        if (composite && this.children == null) {
            this.setChildren(new ArrayList<IWidgetDefinition>());
        }
    }
}

