/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.widget.model;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.IExtensionPointHandler;
import de.intarsys.claptz.IInstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistry;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.InstrumentTools;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import de.intarsys.widget.model.IWidgetDefinition;
import de.intarsys.widget.model.IWidgetDefinitionContainerVisitor;
import de.intarsys.widget.model.IWidgetDefinitionVisitor;
import de.intarsys.widget.model.IWidgetItemFactory;
import de.intarsys.widget.model.StandardWidgetDefinitionFactory;
import de.intarsys.widget.model.WidgetDefinitionContainer;
import de.intarsys.widget.model.WidgetItemOutlet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class DeferredWidgetDefinitionRegistry
extends WidgetDefinitionContainer {
    private static final Logger Log = LoggerFactory.getLogger(DeferredWidgetDefinitionRegistry.class);
    private static final Attribute ATTR_WIDGETFACTORY = new Attribute("widgetFactory");
    public static final String XE_WIDGET = "widget";
    public static final String XE_VISITOR = "visitor";
    public static final String XE_WIDGETS = "widgets";
    public static final String XE_WIDGET_CONFIGURATOR = "widgetconfigurator";
    public static final String XP_WIDGETS = "de.intarsys.widgets";
    public static final String XE_WIDGETITEMFACTORY = "widgetitemfactory";
    private boolean initialized = false;
    private IExtensionPointHandler installerWidgetFactory = new ExtensionPointHandlerAdapter(){

        protected Object basicInstallInsert(IExtension extension, IElement element) {
            if (DeferredWidgetDefinitionRegistry.XE_WIDGETITEMFACTORY.equals(element.getName())) {
                try {
                    IWidgetItemFactory factory = (IWidgetItemFactory)ElementTools.createObject((IElement)element, IWidgetItemFactory.class, (Object)extension.getProvider(), (IArgs)Args.create());
                    String id = element.attributeValue("id", null);
                    WidgetItemOutlet.get().registerWidgetItemFactory(id, factory);
                }
                catch (ObjectCreationException e) {
                    String msg = "error installing extension";
                    this.log(Log, Level.ERROR, extension, element, msg, e);
                }
            }
            return null;
        }
    };
    private IExtensionPointHandler installerWidgetVisitor = new ExtensionPointHandlerAdapter(){

        protected Object basicInstallInsert(IExtension extension, IElement element) {
            String msg;
            Object object;
            String name = element.getName();
            if (DeferredWidgetDefinitionRegistry.XE_VISITOR.equals(name)) {
                try {
                    object = (IWidgetDefinitionVisitor)ElementTools.createObject((IElement)element, IWidgetDefinitionVisitor.class, (Object)extension.getProvider(), (IArgs)Args.create());
                    DeferredWidgetDefinitionRegistry.this.accept((IWidgetDefinitionVisitor)object);
                }
                catch (ObjectCreationException e) {
                    msg = "error installing extension";
                    this.log(Log, Level.ERROR, extension, element, msg, e);
                }
            }
            if (DeferredWidgetDefinitionRegistry.XE_WIDGETS.equals(name) || DeferredWidgetDefinitionRegistry.XE_WIDGET_CONFIGURATOR.equals(name)) {
                try {
                    object = (IWidgetDefinitionContainerVisitor)ElementTools.createObject((IElement)element, IWidgetDefinitionContainerVisitor.class, (Object)extension.getProvider(), (IArgs)Args.create());
                    DeferredWidgetDefinitionRegistry.this.accept((IWidgetDefinitionContainerVisitor)object);
                }
                catch (ObjectCreationException e) {
                    msg = "error installing extension";
                    this.log(Log, Level.ERROR, extension, element, msg, e);
                }
            }
            return null;
        }
    };
    private final IExtensionPointHandler installerWidgetItem = new ExtensionPointHandlerAdapter(){

        protected void basicInstall(IExtension extension) {
            StandardWidgetDefinitionFactory factory = new StandardWidgetDefinitionFactory(DeferredWidgetDefinitionRegistry.this);
            try {
                factory.setContext(extension.getProvider());
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            extension.setAttribute((Object)ATTR_WIDGETFACTORY, (Object)factory);
            super.basicInstall(extension);
        }

        protected Object basicInstallDelete(IExtension extension, IElement element) {
            if (DeferredWidgetDefinitionRegistry.XE_WIDGET.equals(element.getName())) {
                try {
                    IWidgetDefinition widget;
                    Object path = element.attributeValue("register", null);
                    if (path == null) {
                        path = element.attributeValue("parent", null);
                        path = path == null ? element.attributeValue("id", null) : (String)path + "/" + element.attributeValue("id", null);
                    }
                    if ((widget = DeferredWidgetDefinitionRegistry.this.getWidgetDefinition((String)path)) != null) {
                        DeferredWidgetDefinitionRegistry.this.removeWidgetDefinition(widget);
                        widget.dispose();
                        return widget;
                    }
                }
                catch (Exception e) {
                    String msg = "error installing extension";
                    this.log(Log, Level.ERROR, extension, element, msg, e);
                }
            } else {
                return super.basicInstallDelete(extension, element);
            }
            return null;
        }

        protected Object basicInstallInsert(IExtension extension, IElement element) {
            if (DeferredWidgetDefinitionRegistry.XE_WIDGET.equals(element.getName())) {
                StandardWidgetDefinitionFactory factory = (StandardWidgetDefinitionFactory)extension.getAttribute((Object)ATTR_WIDGETFACTORY);
                try {
                    factory.createWidgetDefinition(null, element);
                }
                catch (ObjectCreationException e) {
                    String msg = "error installing extension";
                    this.log(Log, Level.ERROR, extension, element, msg, e);
                }
            }
            return null;
        }

        protected Object basicInstallUpdate(IExtension extension, IElement element) {
            if (DeferredWidgetDefinitionRegistry.XE_WIDGET.equals(element.getName())) {
                try {
                    IWidgetDefinition widget;
                    Object path = element.attributeValue("register", null);
                    if (path == null) {
                        path = element.attributeValue("parent", null);
                        path = path == null ? element.attributeValue("id", null) : (String)path + "/" + element.attributeValue("id", null);
                    }
                    if ((widget = DeferredWidgetDefinitionRegistry.this.getWidgetDefinition((String)path)) instanceof IElementConfigurable) {
                        ((IElementConfigurable)widget).configure(element);
                        return widget;
                    }
                }
                catch (Exception e) {
                    String msg = "error installing extension";
                    this.log(Log, Level.ERROR, extension, element, msg, e);
                }
            } else {
                return super.basicInstallUpdate(extension, element);
            }
            return null;
        }

        protected void basicUninstall(IExtension extension) {
            StandardWidgetDefinitionFactory factory = (StandardWidgetDefinitionFactory)extension.getAttribute((Object)ATTR_WIDGETFACTORY);
            if (factory == null) {
                return;
            }
            for (IWidgetDefinition widget : factory.getWidgetDefinitionRegistry().getWidgetDefinitions()) {
                widget.dispose();
            }
        }
    };

    @Override
    public IWidgetDefinition getWidgetDefinition(String path) {
        this.registerExtensions();
        return super.getWidgetDefinition(path);
    }

    @Override
    public List<IWidgetDefinition> getWidgetDefinitions() {
        this.registerExtensions();
        return super.getWidgetDefinitions();
    }

    protected synchronized void registerExtensions() {
        try {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            InstrumentTools.installExtensions((IInstrumentRegistry)InstrumentRegistry.get(), (String)XP_WIDGETS, (IExtensionPointHandler)this.installerWidgetFactory);
            InstrumentTools.installExtensions((IInstrumentRegistry)InstrumentRegistry.get(), (String)XP_WIDGETS, (IExtensionPointHandler)this.installerWidgetItem);
            if (this.getChildren() != null) {
                Iterator<IWidgetDefinition> itDefs = this.getChildren().iterator();
                while (itDefs.hasNext()) {
                    IWidgetDefinition definition = itDefs.next();
                    IWidgetDefinition tempDef = definition;
                    String parentName = tempDef.getParentName();
                    if (StringTools.isEmpty((String)parentName)) continue;
                    IWidgetDefinition newParent = this.getWidgetDefinition(parentName);
                    if (newParent == null) {
                        Log.warn("widget parent '{}' not found", (Object)parentName);
                        continue;
                    }
                    newParent.addWidgetDefinition(tempDef);
                    if (!StringTools.isEmpty((String)tempDef.getRegisterName())) continue;
                    itDefs.remove();
                }
            }
            InstrumentTools.installExtensions((IInstrumentRegistry)InstrumentRegistry.get(), (String)XP_WIDGETS, (IExtensionPointHandler)this.installerWidgetVisitor);
        }
        catch (InstrumentRegistryException e) {
            Log.warn("error registering extension point 'de.intarsys.widgets'");
        }
    }
}

